/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.EnumMap;
import java.util.EnumSet;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    public ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
        super(javaType, typeFactory);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> clazz, String string) {
    }

    @Override
    public String idFromValue(Object object) {
        return this._idFrom(object, object.getClass());
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        return this._idFrom(object, clazz);
    }

    @Override
    public JavaType typeFromId(String string) {
        if (string.indexOf(60) > 0) {
            JavaType javaType = this._typeFactory.constructFromCanonical(string);
            return javaType;
        }
        try {
            Class<?> clazz = ClassUtil.findClass(string);
            return this._typeFactory.constructSpecializedType(this._baseType, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Invalid type id '" + string + "' (for id type 'Id.class'): no such class found");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid type id '" + string + "' (for id type 'Id.class'): " + exception.getMessage(), exception);
        }
    }

    protected final String _idFrom(Object object, Class<?> clazz) {
        Class<?> clazz2;
        Class<?> clazz3;
        String string;
        if (Enum.class.isAssignableFrom(clazz) && !clazz.isEnum()) {
            clazz = clazz.getSuperclass();
        }
        if ((string = clazz.getName()).startsWith("java.util")) {
            if (object instanceof EnumSet) {
                Class<? extends Enum<?>> clazz4 = ClassUtil.findEnumType((EnumSet)object);
                string = TypeFactory.defaultInstance().constructCollectionType(EnumSet.class, clazz4).toCanonical();
            } else if (object instanceof EnumMap) {
                Class<? extends Enum<?>> clazz5 = ClassUtil.findEnumType((EnumMap)object);
                Class<Object> clazz6 = Object.class;
                string = TypeFactory.defaultInstance().constructMapType(EnumMap.class, clazz5, clazz6).toCanonical();
            } else {
                String string2 = string.substring(9);
                if ((string2.startsWith(".Arrays$") || string2.startsWith(".Collections$")) && string.indexOf("List") >= 0) {
                    string = "java.util.ArrayList";
                }
            }
        } else if (string.indexOf(36) >= 0 && (clazz3 = ClassUtil.getOuterClass(clazz)) != null && ClassUtil.getOuterClass(clazz2 = this._baseType.getRawClass()) == null) {
            clazz = this._baseType.getRawClass();
            string = clazz.getName();
        }
        return string;
    }
}

