/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.cfg;

import java.lang.annotation.Annotation;

public final class AnnotationBundleKey {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private final Annotation[] _annotations;
    private final Class<?> _type;
    private final boolean _annotationsCopied;
    private final int _hashCode;

    @Deprecated
    public AnnotationBundleKey(Annotation[] annotationArray) {
        this(annotationArray, AnnotationBundleKey.class);
    }

    public AnnotationBundleKey(Annotation[] annotationArray, Class<?> clazz) {
        this._type = clazz;
        int n = clazz.getName().hashCode();
        if (annotationArray == null || annotationArray.length == 0) {
            annotationArray = NO_ANNOTATIONS;
            this._annotationsCopied = true;
            this._hashCode = n;
        } else {
            this._annotationsCopied = false;
            this._hashCode = AnnotationBundleKey.calcHash(annotationArray) ^ n;
        }
        this._annotations = annotationArray;
    }

    private AnnotationBundleKey(Annotation[] annotationArray, Class<?> clazz, int n) {
        this._annotations = annotationArray;
        this._annotationsCopied = true;
        this._type = clazz;
        this._hashCode = n;
    }

    private static final int calcHash(Annotation[] annotationArray) {
        int n;
        int n2 = n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + annotationArray[i].hashCode();
        }
        return n2;
    }

    public AnnotationBundleKey immutableKey() {
        if (this._annotationsCopied) {
            return this;
        }
        int n = this._annotations.length;
        Annotation[] annotationArray = new Annotation[n];
        System.arraycopy(this._annotations, 0, annotationArray, 0, n);
        return new AnnotationBundleKey(annotationArray, this._type, this._hashCode);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return "[Annotations: " + this._annotations.length + ", type: " + this._type.getName() + ", hash 0x" + Integer.toHexString(this._hashCode) + ", copied: " + this._annotationsCopied + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        AnnotationBundleKey annotationBundleKey = (AnnotationBundleKey)object;
        if (annotationBundleKey._hashCode != this._hashCode || annotationBundleKey._type != this._type) {
            return false;
        }
        return this._equals(annotationBundleKey._annotations);
    }

    private final boolean _equals(Annotation[] annotationArray) {
        int n = this._annotations.length;
        if (annotationArray.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this._annotations[i] == annotationArray[i]) continue;
            return false;
        }
        return true;
    }
}

