/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.urbancode.air.plugin.command.Build;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class TeamCityClient {
    private static final Logger log = Logger.getLogger(TeamCityClient.class);
    private final String repo;
    private final String buildType;
    private final String branch;
    private final Pattern filenamePattern;
    private final String user;
    private final String password;
    private File tempDir;
    private String latestVersion;

    public TeamCityClient(String repo, String user, String password, String buildType, String branch) throws IOException {
        if (repo.endsWith("/")) {
            repo = repo.substring(0, repo.length() - 1);
        }
        this.repo = repo;
        this.buildType = buildType;
        this.branch = branch;
        this.user = user;
        this.password = password;
        this.filenamePattern = Pattern.compile(".*_(\\p{Graph}+)_artifacts.zip");
    }

    public Build getLatestVersion() throws IOException {
        return this.getVersion(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Build getVersion(String buildId) throws IOException {
        Build result;
        block11: {
            Object version = null;
            result = null;
            String url = this.getBuildUrl(buildId);
            HttpClient client = this.getHttpClient(this.user, this.password);
            try {
                HttpGet method = new HttpGet(url);
                method.setHeader("Accept", "application/json");
                HttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    try {
                        String responseJson = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                        JSONObject json = new JSONObject(responseJson);
                        if (json.getInt("count") == 0) {
                            System.out.println("[Info] JSON Response: " + json.toString());
                            throw new RuntimeException("[Error] Unable to find build. Confirm it exists on the given Build configuration ID and Branch.");
                        }
                        JSONArray builds = json.getJSONArray("build");
                        String buildJson = builds.getJSONObject(0).toString();
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                        result = (Build)mapper.readValue(buildJson, Build.class);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (JsonGenerationException e) {
                        e.printStackTrace();
                    }
                    catch (JsonMappingException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (result == null) {
                        throw new RuntimeException("[Error] Unable to parse TeamCity Build information.");
                    }
                    break block11;
                }
                System.out.println("[Info] HTTP Status Line: " + response.getStatusLine());
                throw new RuntimeException("[Error] Could not identify TeamCity build: " + url);
            }
            finally {
                this.closeClient(client);
            }
        }
        return result;
    }

    public File downloadFiles(String buildId) throws IOException {
        this.download(this.getDownloadUrl(buildId));
        return this.getTempDir();
    }

    private File getTempDir() throws IOException {
        File result = this.tempDir;
        if (result == null) {
            this.tempDir = new File(UUID.randomUUID().toString());
            IO.mkdirs(this.tempDir);
            result = this.tempDir;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String url) throws IOException {
        block4: {
            HttpClient client = this.getHttpClient(this.user, this.password);
            try {
                HttpGet method = new HttpGet(url);
                HttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    this.unzip(response.getEntity().getContent(), this.getTempDir());
                    break block4;
                }
                System.out.println("[Info] HTTP Status Line: " + response.getStatusLine());
                throw new FileNotFoundException(url);
            }
            finally {
                this.closeClient(client);
            }
        }
    }

    private String getDownloadUrl(String buildId) {
        String result;
        try {
            URIBuilder uri = new URIBuilder(this.repo + "/httpAuth/downloadArtifacts.html");
            uri.addParameter("buildId", buildId);
            result = uri.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Download URL is invalid.", e);
        }
        return result;
    }

    private String getBuildUrl(String buildId) {
        String result = "";
        try {
            URIBuilder uri = new URIBuilder(this.repo + "/httpAuth/app/rest/builds");
            String locatorValue = "buildType:" + this.buildType;
            if (this.branch != null && this.branch.length() > 0) {
                locatorValue = locatorValue + ",branch:" + this.branch;
            }
            locatorValue = buildId == null || buildId.equals("") ? locatorValue + ",count:1,status:SUCCESS" : locatorValue + ",buildId:" + buildId;
            uri.addParameter("locator", locatorValue);
            result = uri.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Build URL is invalid: " + result, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(InputStream in, File dest) throws IOException {
        ZipInputStream zin = new ZipInputStream(in);
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                File file = new File(dest, entry.getName());
                if (entry.isDirectory()) {
                    IO.mkdirs(file);
                } else {
                    IO.mkdirs(file.getParentFile());
                    IO.copy((InputStream)zin, file);
                }
                zin.closeEntry();
            }
        }
        finally {
            zin.close();
        }
    }

    public HttpClient getHttpClient(String user, String password) {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTimeoutMillis(60000);
        builder.setTrustAllCerts(true);
        builder.setUsername(user);
        builder.setPassword(password);
        builder.setPreemptiveAuthentication(true);
        DefaultHttpClient result = builder.buildClient();
        return result;
    }

    public void closeClient(HttpClient client) {
        ClientConnectionManager connectionManager = client.getConnectionManager();
        connectionManager.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        connectionManager.shutdown();
    }
}

