/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.SecretUnavailableException;
import java.util.Arrays;

public final class SecretContainerDestroyable
implements SecretContainer {
    private byte[] secret;

    public SecretContainerDestroyable(byte[] secret) {
        secret.getClass();
        this.secret = secret;
    }

    public synchronized void destroy() {
        if (this.secret != null) {
            Arrays.fill(this.secret, (byte)0);
            this.secret = null;
        }
    }

    public synchronized boolean isDestroyed() {
        return this.secret == null;
    }

    public synchronized byte[] getSecret() throws SecretUnavailableException {
        if (this.isDestroyed()) {
            throw new SecretUnavailableException("secret destroyed");
        }
        return this.secret;
    }
}

