/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class TeamCityClient {
    private static final Logger log = Logger.getLogger(TeamCityClient.class);
    private final String repo;
    private final String buildType;
    private final Pattern filenamePattern;
    private final String user;
    private final String password;
    private File tempDir;
    private String latestVersion;

    public TeamCityClient(String repo, String user, String password, String project, String buildConfiguration, String buildType) throws IOException {
        if (repo.endsWith("/")) {
            repo = repo.substring(0, repo.length() - 1);
        }
        this.repo = repo;
        this.buildType = buildType;
        this.user = user;
        this.password = password;
        this.filenamePattern = Pattern.compile(".*_(\\p{Graph}+)_artifacts.zip");
    }

    public String getLatestVersion() throws IOException {
        String result = this.latestVersion;
        if (this.latestVersion == null) {
            String filename = this.getFileName(null);
            Matcher matcher = this.filenamePattern.matcher(filename);
            if (matcher.matches()) {
                result = this.latestVersion = matcher.group(1);
            }
            if (result == null) {
                throw new IOException("Unable to extract version: " + filename);
            }
        }
        return result;
    }

    public String getVersion(int buildId) throws IOException {
        String result = null;
        String filename = this.getFileName(buildId);
        Matcher matcher = this.filenamePattern.matcher(filename);
        if (matcher.matches()) {
            result = matcher.group(1);
        }
        if (result == null) {
            throw new IOException("Unable to extract version: " + filename);
        }
        return result;
    }

    public File downloadFiles(int buildId) throws IOException {
        this.download(this.getDownloadUrl(buildId));
        return this.getTempDir();
    }

    public File downloadLatestFiles() throws IOException {
        this.download(this.getDownloadUrl(null));
        return this.getTempDir();
    }

    private File getTempDir() throws IOException {
        File result = this.tempDir;
        if (result == null) {
            this.tempDir = new File(UUID.randomUUID().toString());
            IO.mkdirs(this.tempDir);
            result = this.tempDir;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String url) throws IOException {
        block4: {
            HttpClient client = this.getHttpClient(this.user, this.password);
            try {
                HttpGet method = new HttpGet(url);
                HttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    this.unzip(response.getEntity().getContent(), this.getTempDir());
                    break block4;
                }
                throw new FileNotFoundException(url);
            }
            finally {
                this.closeClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileName(Integer buildId) throws IOException {
        String result;
        block11: {
            String url = this.getDownloadUrl(buildId);
            HttpClient client = this.getHttpClient(this.user, this.password);
            try {
                HttpHead method = new HttpHead(url);
                HttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    Header dispositionHeader = response.getFirstHeader("Content-Disposition");
                    if (dispositionHeader == null) {
                        throw new IOException("Expected a file attachment, but found none (No Content-Disposition header)");
                    }
                    String disposition = dispositionHeader.getValue();
                    Pattern attachmentPattern = Pattern.compile("attachment; filename=\"([^\"]+)\";");
                    Matcher matcher = attachmentPattern.matcher(disposition);
                    Pattern legacyPattern = Pattern.compile("attachment; filename=([^\"]+)");
                    Matcher legacyMatcher = legacyPattern.matcher(disposition);
                    Pattern newer_Pattern = Pattern.compile("attachment; filename\\*=UTF-8\\'\\'([^\"]+);");
                    Matcher newer_matcher = newer_Pattern.matcher(disposition);
                    if (matcher.matches()) {
                        result = matcher.group(1);
                        log.debug((Object)("matcher: " + result));
                        break block11;
                    }
                    if (legacyMatcher.matches()) {
                        result = legacyMatcher.group(1);
                        log.debug((Object)("legacymatcher: " + result));
                        break block11;
                    }
                    if (newer_matcher.matches()) {
                        result = newer_matcher.group(1);
                        log.debug((Object)("newer_matcher: " + result));
                        break block11;
                    }
                    throw new IOException("Content-Disposition unparseable");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Response Headers:");
                    for (Header header : response.getAllHeaders()) {
                        log.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        log.debug((Object)"Response body:");
                        log.debug((Object)EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
                    }
                }
                throw new RuntimeException("Error importing from " + url + ": HTTP status code " + status);
            }
            finally {
                this.closeClient(client);
            }
        }
        return result;
    }

    private String getDownloadUrl(Integer buildId) {
        String result;
        try {
            URIBuilder uri = new URIBuilder(this.repo).setPath("/httpAuth/downloadArtifacts.html");
            if (buildId != null) {
                uri.addParameter("buildId", Integer.toString(buildId));
            } else {
                uri.addParameter("buildTypeId", this.buildType);
                uri.addParameter("buildId", "lastSuccessful");
            }
            result = uri.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Download URL is invalid.", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(InputStream in, File dest) throws IOException {
        ZipInputStream zin = new ZipInputStream(in);
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                File file = new File(dest, entry.getName());
                if (entry.isDirectory()) {
                    IO.mkdirs(file);
                } else {
                    IO.mkdirs(file.getParentFile());
                    IO.copy((InputStream)zin, file);
                }
                zin.closeEntry();
            }
        }
        finally {
            zin.close();
        }
    }

    public HttpClient getHttpClient(String user, String password) {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTimeoutMillis(60000);
        builder.setTrustAllCerts(true);
        builder.setUsername(user);
        builder.setPassword(password);
        builder.setPreemptiveAuthentication(true);
        DefaultHttpClient result = builder.buildClient();
        return result;
    }

    public void closeClient(HttpClient client) {
        ClientConnectionManager connectionManager = client.getConnectionManager();
        connectionManager.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        connectionManager.shutdown();
    }
}

