/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.Build;
import com.urbancode.air.plugin.command.TeamCityClient;
import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        block15: {
            File tempDir = null;
            Build buildObj = null;
            try {
                List versions;
                boolean hasVersion;
                Properties props = new Properties();
                props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
                PropertyConfigurator.configure((Properties)props);
                Properties agentProps = new Properties();
                agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
                String charsetName = agentProps.getProperty("system.default.encoding");
                String extensionString = this.inputProperties.getProperty("extensions");
                String[] extensions = new String[]{};
                if (extensionString != null) {
                    extensions = extensionString.split(",");
                    for (int i = 0; i < extensions.length; ++i) {
                        extensions[i] = extensions[i].trim();
                    }
                }
                Charset charset = null;
                if (charsetName != null) {
                    charset = Charset.forName(charsetName);
                }
                String componentName = this.inputProperties.getProperty("componentName");
                String repoUrl = this.inputProperties.getProperty("repoUrl");
                String tcUsername = this.inputProperties.getProperty("user");
                String tcPassword = this.inputProperties.getProperty("password");
                String buildType = this.inputProperties.getProperty("buildType");
                String branch = this.inputProperties.getProperty("branch");
                String versionName = this.inputProperties.getProperty("versionName");
                String buildId = this.inputProperties.getProperty("buildId");
                String[] includes = new String[]{"**/*"};
                String[] excludes = new String[]{};
                boolean preserveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
                String username = "PasswordIsAuthToken";
                String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
                String webUrl = System.getenv("AH_WEB_URL");
                URI url = new URI(webUrl);
                VersionClient versionClient = new VersionClient(url, username, password);
                ComponentClient componentClient = new ComponentClient(url, username, password);
                TeamCityClient client = new TeamCityClient(repoUrl, tcUsername, tcPassword, buildType, branch);
                buildObj = StringUtils.isEmpty((CharSequence)buildId) ? client.getLatestVersion() : client.getVersion(buildId);
                String version = buildObj.getNumber();
                if (!StringUtils.isEmpty((CharSequence)versionName)) {
                    version = versionName;
                }
                if (!(hasVersion = (versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false))).contains(version))) {
                    System.out.println("Creating new version " + version + ".");
                    String versionId = versionClient.createVersion(componentName, version, " ", true).toString();
                    this.outputProperties.setProperty("VersionID", versionId);
                    try {
                        versionClient.setVersionProperty(version, componentName, "id", buildObj.getId(), false);
                        versionClient.setVersionProperty(version, componentName, "buildTypeId", buildObj.getBuildTypeId(), false);
                        versionClient.setVersionProperty(version, componentName, "number", buildObj.getNumber(), false);
                        versionClient.setVersionProperty(version, componentName, "status", buildObj.getStatus(), false);
                        versionClient.setVersionProperty(version, componentName, "branchName", buildObj.getBranchName(), false);
                        versionClient.setVersionProperty(version, componentName, "defaultBranch", String.valueOf(buildObj.isDefaultBranch()), false);
                        versionClient.setVersionProperty(version, componentName, "href", buildObj.getHref(), false);
                        versionClient.setVersionProperty(version, componentName, "webUrl", buildObj.getWebUrl(), false);
                    }
                    catch (IOException ex) {
                        System.out.println("");
                        System.out.println("[Warn] Unable to assign 'id', 'buildTypeId', 'number', 'status', 'branchName', 'defaultBranch', 'href', and 'webUrl' component version properties.");
                        System.out.println("Manually create these properties in the Version Properties Definitions section of the `${componentName}` component's configuration tab.");
                    }
                    if (isUseVFS) {
                        System.out.println("Uploading files to VFS");
                        tempDir = client.downloadFiles(buildObj.getId());
                        versionClient.addVersionFiles(componentName, versionId, tempDir, "", includes, excludes, preserveExecutePermissions, true, charset, extensions);
                    } else {
                        System.out.println(String.format("Not uploading version %s to VFS because using VFS was not selected.", versionId));
                    }
                    versionClient.markImportFinished(componentName, versionId);
                    System.out.println("Successfully imported version " + version + ".");
                    break block15;
                }
                System.out.println(String.format("UCD already contains version %s", version));
            }
            catch (Exception e) {
                System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
                e.printStackTrace();
                int n = 1;
                return n;
            }
            finally {
                if (tempDir != null) {
                    FileUtils.deleteFile(tempDir);
                }
            }
        }
        return 0;
    }
}

