/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.AWSRoleAssume;
import com.urbancode.air.plugin.command.InputValidator;
import com.urbancode.air.plugin.command.Operation;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public class RunTerraformFile {
    private final Properties inputProperties;
    private final Properties outputProperties;
    private Operation operation;

    public RunTerraformFile(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        InputValidator validator = InputValidator.getValidatedInputs(this.inputProperties);
        String sessionName = "AmSession18";
        System.out.println("Assuming role....");
        String[] vals = AWSRoleAssume.assumeRole(validator.getRoleArn(), sessionName);
        String filePath = validator.getTerraformFile();
        ArrayList<String> tfCommandPath = validator.getTerraformCommand();
        String tfDirectory = Paths.get(filePath, new String[0]).getParent().toString();
        try {
            System.out.println("Initializing Terraform...");
            tfCommandPath.add("init");
            this.runCommand(tfCommandPath.toArray(new String[0]), tfDirectory, vals);
            tfCommandPath.remove(tfCommandPath.size() - 1);
            tfCommandPath.add(validator.getOperation().toString());
            this.operation = validator.getOperation();
            if (this.operation != Operation.PLAN) {
                tfCommandPath.add("-auto-approve");
            }
            System.out.println("Running Terraform command " + (Object)((Object)validator.getOperation()));
            this.runCommand(tfCommandPath.toArray(new String[0]), tfDirectory, vals);
            System.out.println("Terraform execution completed successfully.");
            return 0;
        }
        catch (Exception e) {
            System.err.println("An error occurred during Terraform execution: " + e.getMessage());
            return 1;
        }
    }

    void runCommand(String[] command, String directory, String[] vals) throws Exception {
        String line;
        if (vals.length != 3) {
            System.err.println("Some issue in assuming role... ");
            throw new Exception("Terraform command failure when processing command " + Arrays.toString(command));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(new File(directory));
        processBuilder.redirectErrorStream(true);
        Map<String, String> env = processBuilder.environment();
        env.put("AWS_ACCESS_KEY_ID", vals[0]);
        env.put("AWS_SECRET_ACCESS_KEY", vals[1]);
        env.put("AWS_SESSION_TOKEN", vals[2]);
        Process process = processBuilder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
            if (this.operation != Operation.PLAN || !line.contains("Plan")) continue;
            this.setOutputProps(line);
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            System.err.println("Command failed with exit code: " + exitCode);
            throw new Exception("Terraform command failure when processing command " + Arrays.toString(command));
        }
    }

    private void setOutputProps(String line) {
        String[] opVars = line.split("\\s+");
        this.outputProperties.setProperty("add", opVars[1]);
        this.outputProperties.setProperty("change", opVars[4]);
        this.outputProperties.setProperty("destroy", opVars[7]);
    }
}

