/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class AWSRoleAssume {
    public static String[] assumeRole(String roleArn, String sessionName) {
        String[] res = new String[3];
        try {
            String command = String.format("aws sts assume-role --role-arn \"%s\" --role-session-name \"%s\"", roleArn, sessionName);
            String response = AWSRoleAssume.getResponse(command);
            if (response.contains("Credentials")) {
                String accessKeyId = AWSRoleAssume.extractJsonValue(response, "AccessKeyId");
                String secretAccessKey = AWSRoleAssume.extractJsonValue(response, "SecretAccessKey");
                String sessionToken = AWSRoleAssume.extractJsonValue(response, "SessionToken");
                res[0] = accessKeyId;
                res[1] = secretAccessKey;
                res[2] = sessionToken;
                return res;
            }
            System.err.println("Failed to assume role. Response: " + response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    static String getResponse(String command) throws IOException, InterruptedException {
        String line;
        ProcessBuilder processBuilder = new ProcessBuilder(AWSRoleAssume.getCommand()[0], AWSRoleAssume.getCommand()[1], command);
        Process process = processBuilder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder output = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            output.append(line);
        }
        process.waitFor();
        return output.toString();
    }

    static String extractJsonValue(String json, String key) {
        String regex = String.format("\"%s\":\\s*\"(.*?)\"", key);
        return json.matches(".*" + regex + ".*") ? json.replaceAll(".*" + regex + ".*", "$1") : null;
    }

    private static String[] getCommand() {
        if (System.getProperty("os.name").contains("Windows")) {
            return new String[]{"cmd.exe", "/c"};
        }
        return new String[]{"bash", "-c"};
    }
}

