/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.Check;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class NamePattern
implements Serializable {
    private static final Logger log = Logger.getLogger(NamePattern.class);
    private static final long serialVersionUID = 1L;
    public static final String ALL = "*";
    protected String queryPattern;
    protected transient String sqlPattern;

    public NamePattern() {
        this.queryPattern = null;
        this.sqlPattern = null;
    }

    public NamePattern(String queryPattern) throws NamePatternSyntaxException {
        Check.nonNull(queryPattern, "queryPattern");
        queryPattern = queryPattern.trim();
        if (queryPattern.length() == 0) {
            queryPattern = ALL;
        }
        this.queryPattern = queryPattern;
        this.sqlPattern = this.translate(queryPattern);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pattern " + queryPattern + " translated to " + this.sqlPattern));
        }
    }

    public boolean isAll() {
        return this.getQueryPattern().equals(ALL);
    }

    public String getQueryPattern() {
        return this.queryPattern;
    }

    public String getSqlPattern() {
        return this.sqlPattern;
    }

    protected String translate(String string) throws NamePatternSyntaxException {
        StringBuilder builder = new StringBuilder();
        boolean inEscape = false;
        block8: for (char c : string.toCharArray()) {
            switch (c) {
                case '*': {
                    if (inEscape) {
                        builder.append('*');
                        inEscape = false;
                        continue block8;
                    }
                    builder.append('%');
                    continue block8;
                }
                case '?': {
                    if (inEscape) {
                        builder.append('?');
                        inEscape = false;
                        continue block8;
                    }
                    builder.append('_');
                    continue block8;
                }
                case '%': {
                    builder.append("!%");
                    continue block8;
                }
                case '_': {
                    builder.append("!_");
                    continue block8;
                }
                case '!': {
                    builder.append("!!");
                    continue block8;
                }
                case '\\': {
                    if (inEscape) {
                        builder.append('\\');
                        inEscape = false;
                        continue block8;
                    }
                    inEscape = true;
                    continue block8;
                }
                default: {
                    if (inEscape) {
                        throw new NamePatternSyntaxException("Name pattern contained invalid escape sequence '" + c + "'");
                    }
                    builder.append(c);
                }
            }
        }
        if (inEscape) {
            throw new NamePatternSyntaxException("Name pattern ended with an incomplete escape sequence");
        }
        return builder.toString();
    }

    protected Object readResolve() throws ObjectStreamException {
        NamePattern result;
        try {
            result = new NamePattern(this.queryPattern);
        }
        catch (NamePatternSyntaxException e) {
            throw (InvalidObjectException)new InvalidObjectException(e.getMessage()).initCause(e);
        }
        return result;
    }

    public static class NamePatternSyntaxException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NamePatternSyntaxException() {
        }

        public NamePatternSyntaxException(String message, Throwable cause) {
            super(message, cause);
        }

        public NamePatternSyntaxException(String message) {
            super(message);
        }

        public NamePatternSyntaxException(Throwable cause) {
            super(cause);
        }
    }
}

