/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.urbancode.commons.util.immutable.IImmutableMap;
import com.urbancode.commons.util.immutable.IImmutableSet;
import com.urbancode.commons.util.immutable.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

abstract class AImmutableSet<T>
implements IImmutableSet<T>,
Set<T> {
    int _hash = -1;
    final IImmutableMap<T, T> impl;

    protected AImmutableSet(IImmutableMap<T, T> impl) {
        this.impl = impl;
    }

    public String toString() {
        return Util.toString(this, this.iterator());
    }

    @Override
    public boolean contains(Object key) {
        return this.impl.containsKey(key);
    }

    @Override
    public T get(T key) {
        return (T)this.impl.get(key);
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Set)) {
            return false;
        }
        Set set = (Set)obj;
        if (set.size() != this.size() || set.hashCode() != this.hashCode()) {
            return false;
        }
        for (Object e : set) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash = 0;
            for (T e : this) {
                hash += Util.hash(e);
            }
            this._hash = hash;
        }
        return this._hash;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return Util.toArray(this.size(), this.iterator(), array);
    }

    @Override
    public Object[] toArray() {
        return Util.toArray(this.size(), this.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return this.impl.keySet().iterator();
    }
}

