/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.AssumeRoleAuthenticationException;
import com.urbancode.air.plugin.command.ProcessHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AwsHelper {
    public static Map<String, String> assumeRole(String roleArn, String sessionName) throws AssumeRoleAuthenticationException {
        String command = String.format("aws sts assume-role --role-arn \"%s\" --role-session-name \"%s\"", roleArn, sessionName);
        try {
            JSONObject responseJson = new JSONObject(AwsHelper.getResponse(command));
            return AwsHelper.extractAwsEnvCredentials(responseJson);
        }
        catch (JSONException e) {
            throw new AssumeRoleAuthenticationException("Unable to assume role for AWS using supplied role " + e.getMessage() + e.getColumn());
        }
    }

    public static Map<String, String> extractAwsEnvCredentials(JSONObject responseJson) throws AssumeRoleAuthenticationException {
        try {
            JSONObject authJson = responseJson.getJSONObject("Credentials");
            String accessKeyId = authJson.getString("AccessKeyId");
            String secretAccessKey = authJson.getString("SecretAccessKey");
            String sessionToken = authJson.getString("SessionToken");
            if (accessKeyId == null || secretAccessKey == null || sessionToken == null) {
                throw new AssumeRoleAuthenticationException(" Unable to set session parameters");
            }
            HashMap<String, String> awsEnvProperties = new HashMap<String, String>();
            awsEnvProperties.put("AWS_ACCESS_KEY_ID", accessKeyId);
            awsEnvProperties.put("AWS_SECRET_ACCESS_KEY", secretAccessKey);
            awsEnvProperties.put("AWS_SESSION_TOKEN", sessionToken);
            return awsEnvProperties;
        }
        catch (JSONException e) {
            throw new AssumeRoleAuthenticationException("Failed to assume role as Credentials Json was in unexpected format");
        }
    }

    static String getResponse(String processCommand) {
        String[] osBashCommand = AwsHelper.getCommand();
        String[] processCommands = new String[]{osBashCommand[0], osBashCommand[1], processCommand};
        return ProcessHelper.runCommandsInAProcess(processCommands, Optional.empty(), Optional.empty()).toString();
    }

    private static String[] getCommand() {
        if (System.getProperty("os.name").contains("Windows")) {
            return new String[]{"cmd.exe", "/c"};
        }
        return new String[]{"bash", "-c"};
    }
}

