/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public class ProcessHelper {
    static StringBuilder runCommandsInAProcess(String[] command, Optional<String> directory, Optional<Map<String, String>> envProperties) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        directory.ifPresent(s -> processBuilder.directory(new File((String)s)));
        processBuilder.redirectErrorStream(true);
        envProperties.ifPresent(s -> {
            Map<String, String> env = processBuilder.environment();
            env.putAll((Map<String, String>)s);
        });
        StringBuilder processOutput = new StringBuilder();
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                processOutput.append(line).append("\n");
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                System.err.println("Command failed with exit code: " + exitCode);
                throw new RuntimeException("Failure when processing command " + Arrays.toString(command));
            }
        }
        catch (IOException | InterruptedException f) {
            throw new RuntimeException("Failure when processing command " + Arrays.toString(command) + " with message " + f.getMessage() + " with cause " + f.getCause());
        }
        return processOutput;
    }
}

