/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class TerraformProviderIdentifier {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Provider findProvider(File tfFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(tfFile));){
            String line;
            do {
                if ((line = br.readLine()) == null) return Provider.AWS;
            } while (!line.trim().startsWith("provider") || !line.contains("\"google\""));
            Provider provider = Provider.GOOGLE;
            return provider;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to determine Terraform provider from the file " + tfFile);
        }
    }

    static enum Provider {
        GOOGLE,
        AWS;

    }
}

