/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.Envelope;
import com.urbancode.air.securedata.EnvelopeDecoder;
import com.urbancode.air.securedata.EnvelopeEncoder;
import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.crypto.CryptoEngine;
import com.urbancode.air.securedata.crypto.CryptoSuite;
import com.urbancode.air.securedata.crypto.DefaultCryptoEngine;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;

public class EnvelopeCodec {
    private static final long DEFAULT_SKEW = Long.valueOf(System.getProperty("com.urbancode.air.securedata.timestampSkew", "300000"));
    private final String cryptoSuite;
    private final EnvelopeEncoder encoder;
    private final EnvelopeDecoder decoder;

    public static Builder builder() {
        return new Builder();
    }

    EnvelopeCodec(CryptoEngine engine, String cryptoSuite, SecretContainer secret, long maxTimestampSkew) {
        CryptoSuite suite = engine.getCryptoSuite(cryptoSuite);
        SecureRandom random = engine.getRandom();
        this.decoder = new EnvelopeDecoder(secret, suite, maxTimestampSkew);
        this.encoder = new EnvelopeEncoder(secret, suite, random);
        this.cryptoSuite = cryptoSuite;
    }

    public String getCryptoSuite() {
        return this.cryptoSuite;
    }

    public void encodeBody(Envelope envelope) throws GeneralSecurityException {
        this.encoder.encodeBody(envelope);
    }

    public void decodeBody(Envelope envelope) throws GeneralSecurityException {
        this.decoder.decodeBody(envelope);
    }

    static /* synthetic */ long access$000() {
        return DEFAULT_SKEW;
    }

    public static class Builder {
        private CryptoEngine engine;
        private String cryptoSuite;
        private SecretContainer secret;
        private long maxTimestampSkew = EnvelopeCodec.access$000();

        Builder() {
        }

        public Builder setCryptoEngine(CryptoEngine engine) {
            this.engine = engine;
            return this;
        }

        public Builder setCryptoSuite(String cryptoSuite) {
            this.cryptoSuite = cryptoSuite;
            return this;
        }

        public Builder setSecret(SecretContainer secret) {
            this.secret = secret;
            return this;
        }

        public Builder setMaxTimestampSkew(long maxTimestampSkew) {
            this.maxTimestampSkew = maxTimestampSkew;
            return this;
        }

        public EnvelopeCodec build() throws GeneralSecurityException {
            CryptoEngine engine = this.engine;
            String cryptoSuite = this.cryptoSuite;
            SecretContainer secret = this.secret;
            long maxTimestampSkew = this.maxTimestampSkew;
            if (maxTimestampSkew < 0L) {
                maxTimestampSkew = 0L;
            }
            if (engine == null) {
                engine = DefaultCryptoEngine.get();
            }
            if (cryptoSuite == null) {
                cryptoSuite = "AES:128-HMAC:SHA256";
            }
            if (secret == null) {
                throw new IllegalStateException("no secret");
            }
            return new EnvelopeCodec(engine, cryptoSuite, secret, maxTimestampSkew);
        }
    }
}

