/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AzureHelper {
    private final String clientID;
    private final String secretKey;
    private final String sshKey;
    private final String azureVMName;

    public AzureHelper(Properties inputProperties) {
        this.clientID = inputProperties.getProperty("clientID").trim();
        this.secretKey = inputProperties.getProperty("secretKey").trim();
        this.sshKey = inputProperties.getProperty("sshKey").trim();
        this.azureVMName = inputProperties.getProperty("azureVMName").trim();
    }

    public boolean validateClientID() {
        if (this.clientID == null || this.clientID.trim().isEmpty()) {
            throw new IllegalArgumentException("Client ID input is required.");
        }
        String trimmedCred = this.clientID.trim();
        if (trimmedCred.startsWith("{") && trimmedCred.endsWith("}") || trimmedCred.startsWith("[") && trimmedCred.endsWith("]")) {
            System.out.println("[Client ID provided from property]");
            return true;
        }
        throw new IllegalArgumentException("Client ID is missing.");
    }

    public boolean validateAzureVMName() {
        if (this.azureVMName == null || this.azureVMName.trim().isEmpty()) {
            throw new IllegalArgumentException("Azure VM Name input is required.");
        }
        String vmName = this.azureVMName.trim();
        if (this.isPropertyReference(vmName)) {
            System.out.println("[Azure VM Name provided via property reference]");
            return true;
        }
        if (this.isValidAzureVMName(vmName)) {
            System.out.println("[Valid Azure VM Name provided]");
            return true;
        }
        throw new IllegalArgumentException("Invalid Azure VM Name. Must be 1\u201364 characters, contain only letters, numbers, and hyphens, and start/end with an alphanumeric character.");
    }

    private boolean isPropertyReference(String value) {
        return value.startsWith("${") && value.endsWith("}") || value.startsWith("$(") && value.endsWith(")") || value.startsWith("{") && value.endsWith("}") || value.startsWith("[") && value.endsWith("]");
    }

    private boolean isValidAzureVMName(String vmName) {
        if (vmName.length() < 1 || vmName.length() > 64) {
            return false;
        }
        String azureVmRegex = "^[a-zA-Z0-9]([a-zA-Z0-9-]*[a-zA-Z0-9])?$";
        return vmName.matches(azureVmRegex);
    }

    public boolean validateSecretKey() {
        if (this.secretKey == null || this.secretKey.trim().isEmpty()) {
            throw new IllegalArgumentException("Secret Key input is required.");
        }
        String trimmedCred = this.secretKey.trim();
        if (trimmedCred.startsWith("{") && trimmedCred.endsWith("}") || trimmedCred.startsWith("[") && trimmedCred.endsWith("]")) {
            System.out.println("[Secret Key provided from property]");
            return true;
        }
        throw new IllegalArgumentException("Secret Key is missing.");
    }

    public boolean validateSshPublicKey() {
        if (this.sshKey == null || this.sshKey.trim().isEmpty()) {
            throw new IllegalArgumentException("SSH public key file path is required.");
        }
        String trimmedssh = this.sshKey.trim();
        File file = new File(trimmedssh);
        if (file.exists() && file.isFile() && trimmedssh.toLowerCase().endsWith(".pub")) {
            System.out.println("[SSH public key validated from file path]");
            return true;
        }
        System.out.println("[Invalid SSH public key file]");
        throw new IllegalArgumentException("Invalid SSH public key. Provide a valid .pub file path.");
    }

    static boolean isAzureTerraform(File tfFile) {
        try {
            List<String> lines = Files.readAllLines(tfFile.toPath());
            for (String line : lines) {
                String trimmed = line.trim();
                if (trimmed.startsWith("#") || trimmed.startsWith("//") || !trimmed.contains("provider \"azurerm\"")) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read Terraform file for provider validation", e);
        }
    }

    static void handleAzureSshKey(File tfOutputFile, boolean isAzureProvider, String sshKey) {
        if (!isAzureProvider || sshKey == null || sshKey.trim().isEmpty()) {
            return;
        }
        Path tempDir = tfOutputFile.getParentFile().toPath();
        Path sshSourcePath = Paths.get(sshKey.trim(), new String[0]);
        Path sshDestPath = tempDir.resolve("dev_key.pub");
        if (!Files.exists(sshSourcePath, new LinkOption[0])) {
            throw new IllegalArgumentException("SSH key file does not exist: " + sshKey);
        }
        try {
            Files.copy(sshSourcePath, sshDestPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("SSH key saved at: " + sshDestPath.toAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy SSH key", e);
        }
    }

    static void injectAzureCredentials(File tfFile, String clientID, String secretKey, String tenantId) {
        try {
            String tfContent = new String(Files.readAllBytes(tfFile.toPath()));
            if (!tfContent.contains("provider \"azurerm\"")) {
                return;
            }
            if (tfContent.contains("client_id") || tfContent.contains("client_secret")) {
                return;
            }
            String credentialsBlock = "  client_id       = \"" + clientID.trim() + "\"\n  client_secret   = \"" + secretKey.trim() + "\"\n  tenant_id       = \"" + tenantId.trim() + "\"\n";
            tfContent = tfContent.replaceFirst("(provider\\s+\"azurerm\"\\s*\\{[\\s\\S]*?subscription_id\\s*=\\s*\"[^\"]+\")", "$1\n" + credentialsBlock);
            Files.write(tfFile.toPath(), tfContent.getBytes(), new OpenOption[0]);
            System.out.println("Azure credentials injected into Terraform provider");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to inject Azure credentials", e);
        }
    }

    static boolean isNotBlank(String value) {
        return value != null && !value.trim().isEmpty();
    }

    static void injectAzureVMAndNicNames(File tfFile, String vmNameInput) {
        try {
            String tfContent = new String(Files.readAllBytes(tfFile.toPath()));
            if (vmNameInput == null || vmNameInput.trim().isEmpty()) {
                throw new IllegalArgumentException("VM name input is required");
            }
            String vmName = vmNameInput.trim();
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            String nicName = vmName + "-nic-" + timestamp;
            tfContent = AzureHelper.replaceOrInjectName(tfContent, "azurerm_network_interface", "nic", nicName);
            tfContent = AzureHelper.replaceOrInjectName(tfContent, "azurerm_linux_virtual_machine", "vm", vmName);
            Files.write(tfFile.toPath(), tfContent.getBytes(), new OpenOption[0]);
            System.out.println("Azure VM and NIC names injected/replaced successfully");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to inject Azure VM/NIC names", e);
        }
    }

    private static String replaceOrInjectName(String tfContent, String resourceType, String resourceLabel, String nameValue) {
        String resourceRegex = "(resource\\s+\"" + resourceType + "\"\\s+\"" + resourceLabel + "\"\\s*\\{[\\s\\S]*?\\n\\})";
        Pattern pattern = Pattern.compile(resourceRegex);
        Matcher matcher = pattern.matcher(tfContent);
        if (!matcher.find()) {
            return tfContent;
        }
        String resourceBlock = matcher.group(1);
        int firstNestedBlockIndex = resourceBlock.indexOf("\n  ip_configuration");
        if (firstNestedBlockIndex == -1) {
            firstNestedBlockIndex = resourceBlock.length();
        }
        String headerPart = resourceBlock.substring(0, firstNestedBlockIndex);
        String bodyPart = resourceBlock.substring(firstNestedBlockIndex);
        headerPart = headerPart.matches("(?s).*\\n\\s*name\\s*=.*") ? headerPart.replaceFirst("(\\n\\s*name\\s*=\\s*\")[^\"]+(\")", "$1" + nameValue + "$2") : headerPart.replaceFirst("(resource\\s+\"" + resourceType + "\"\\s+\"" + resourceLabel + "\"\\s*\\{)", "$1\n  name                = \"" + nameValue + "\"");
        return tfContent.replace(matcher.group(1), headerPart + bodyPart);
    }
}

