/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;

public class GcpHelper {
    private final String gcpCred;

    public GcpHelper(Properties inputProperties) {
        this.gcpCred = inputProperties.getProperty("gcpCred").trim();
    }

    public boolean validateGcpCred() {
        if (this.gcpCred == null || this.gcpCred.trim().isEmpty()) {
            throw new IllegalArgumentException("GCP Credentials input is required.");
        }
        String trimmedCred = this.gcpCred.trim();
        File file = new File(trimmedCred);
        if (file.exists() && file.isFile() && trimmedCred.toLowerCase().endsWith(".json")) {
            System.out.println("[GCP Credentials validated from file path]");
            return true;
        }
        if (trimmedCred.startsWith("{") && trimmedCred.endsWith("}") || trimmedCred.startsWith("[") && trimmedCred.endsWith("]")) {
            System.out.println("[GCP Credentials validated from property]");
            return true;
        }
        throw new IllegalArgumentException("Invalid GCP Credentials. Provide a valid .json file path or raw JSON string.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasCredentialsInScript(File tfFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(tfFile));){
            String line;
            String trimmed;
            do {
                if ((line = br.readLine()) == null) return false;
            } while (!(trimmed = line.trim()).startsWith("credentials") && !trimmed.contains("credentials ="));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process TF file " + tfFile + " to check for credentials");
        }
    }

    public Map<String, String> getActivateGcpServiceAccountKeyFile() throws IOException, InterruptedException {
        String resolvedKeyFilePath = this.getGcpResolvedKeyFile();
        String gcloudCommand = GcpHelper.detectGcloudCommand();
        System.out.println("[gcloudCommand] " + gcloudCommand);
        ProcessBuilder authBuilder = new ProcessBuilder(gcloudCommand, "auth", "activate-service-account", "--key-file=" + resolvedKeyFilePath);
        authBuilder.redirectErrorStream(true);
        Map<String, String> env = authBuilder.environment();
        env.put("GOOGLE_APPLICATION_CREDENTIALS", resolvedKeyFilePath);
        Process authProcess = authBuilder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(authProcess.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        int authExitCode = authProcess.waitFor();
        if (authExitCode != 0) {
            throw new RuntimeException("GCP authentication failed with exit code: " + authExitCode);
        }
        System.out.println("GCP authentication successful!");
        System.out.println("GOOGLE_APPLICATION_CREDENTIALS set to: " + resolvedKeyFilePath);
        return env;
    }

    private String getGcpResolvedKeyFile() throws IOException {
        String resolvedKeyFilePath;
        File credFile = new File(this.gcpCred);
        if (credFile.exists() && credFile.isFile() && this.gcpCred.toLowerCase().endsWith(".json")) {
            System.out.println("[Using credentials from file path]");
            resolvedKeyFilePath = credFile.getAbsolutePath();
        } else if (this.gcpCred.trim().startsWith("{") && this.gcpCred.trim().endsWith("}") || this.gcpCred.trim().startsWith("[") && this.gcpCred.trim().endsWith("]")) {
            System.out.println("[Using credentials from raw JSON property]");
            File tempFile = File.createTempFile("gcp-credentials-", ".json");
            tempFile.deleteOnExit();
            try (FileWriter writer = new FileWriter(tempFile);){
                writer.write(this.gcpCred);
            }
            resolvedKeyFilePath = tempFile.getAbsolutePath();
        } else {
            throw new IllegalArgumentException("Invalid GCP Credentials. Provide a valid .json file path or raw JSON string.");
        }
        return resolvedKeyFilePath;
    }

    private static String detectGcloudCommand() throws IOException {
        String gcloudPath;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            String gcloudPath2 = GcpHelper.findGcloudSource("where", "gcloud");
            if (gcloudPath2 != null && !gcloudPath2.isEmpty()) {
                File cmdFile = new File((gcloudPath2 = gcloudPath2.trim()) + ".cmd");
                if (cmdFile.exists()) {
                    return cmdFile.getAbsolutePath();
                }
                File exeFile = new File(gcloudPath2 + ".exe");
                if (exeFile.exists()) {
                    return exeFile.getAbsolutePath();
                }
                if (gcloudPath2.toLowerCase().endsWith(".cmd") || gcloudPath2.toLowerCase().endsWith(".exe")) {
                    return gcloudPath2;
                }
            }
        } else if ((os.contains("mac") || os.contains("nix") || os.contains("nux")) && (gcloudPath = GcpHelper.findGcloudSource("which", "gcloud")) != null && !gcloudPath.isEmpty()) {
            return gcloudPath.trim();
        }
        return "gcloud";
    }

    private static String findGcloudSource(String ... command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String string = reader.readLine();
            return string;
        }
    }
}

