/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.AzureHelper;
import com.urbancode.air.plugin.command.Operation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;

public class InputValidator {
    private static Path tempDir;
    String tfCommandPath;
    String tfFilePath;
    String roleArn;
    Operation operation;
    String sshKey;
    String clientID;
    String secretKey;
    String tenantId;
    String azureVMName;
    private static final String TERRAFORM = "/terraform";
    private static final String TERRAFORM_WINDOWS = "\\terraform.exe";

    InputValidator(Properties inputProperties) {
        this.tfFilePath = inputProperties.getProperty("tfFilePath").trim();
        this.tfCommandPath = InputValidator.addSlashIfNeeded(inputProperties.getProperty("tfPath")).trim();
        this.roleArn = inputProperties.getProperty("awsRoleName").trim();
        this.operation = Operation.valueOf(inputProperties.getProperty("opType"));
        this.sshKey = inputProperties.getProperty("sshKey").trim();
        this.clientID = inputProperties.getProperty("clientID").trim();
        this.secretKey = inputProperties.getProperty("secretKey").trim();
        this.tenantId = inputProperties.getProperty("tenantId").trim();
        this.azureVMName = inputProperties.getProperty("azureVMName").trim();
    }

    static InputValidator getValidatedInputs(Properties inputProps) {
        InputValidator validator = new InputValidator(inputProps);
        validator.validateTfPath();
        validator.validateTfFilePath();
        return validator;
    }

    static String addSlashIfNeeded(String tfPath) {
        if (!tfPath.isEmpty() && tfPath.charAt(tfPath.length() - 1) != '/') {
            return tfPath + "/";
        }
        return tfPath;
    }

    void validateTfPath() {
        if (this.tfCommandPath.isEmpty()) {
            throw new IllegalArgumentException("Terraform binary path is required.");
        }
        File file = new File(this.tfCommandPath);
        if (!file.exists() || !file.canExecute()) {
            throw new IllegalArgumentException("Invalid Terraform binary path or not executable: " + this.tfCommandPath);
        }
        if (!InputValidator.isTerraformCLI(this.tfCommandPath)) {
            throw new IllegalArgumentException("Invalid Terraform command path. Please install terraform or verify path.");
        }
        if (this.tfCommandPath.endsWith("\\") || this.tfCommandPath.endsWith("/")) {
            this.tfCommandPath = this.tfCommandPath.substring(0, this.tfCommandPath.length() - 1);
        }
    }

    void validateAwsRoleName() {
        if (this.roleArn == null || this.roleArn.trim().isEmpty()) {
            throw new IllegalArgumentException("A Valid AWS Role Name (awsRoleName) is required.");
        }
    }

    public static boolean isTerraformCLI(String terraformPath) {
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(terraformPath + TERRAFORM, "-version");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line).append(System.lineSeparator());
            }
            int exitCode = process.waitFor();
            return exitCode == 0 && output.toString().contains("Terraform");
        }
        catch (Exception e) {
            System.err.println("An error occurred while verifying the Terraform CLI: " + e.getMessage());
            return false;
        }
    }

    void validateTfFilePath() {
        File tfOutputFile;
        if (InputValidator.isValidPathAndExists(this.tfFilePath)) {
            InputValidator.validateTfFile(this.tfFilePath);
            this.tfFilePath = this.tfFilePath.trim();
            tfOutputFile = new File(this.tfFilePath);
        } else {
            try {
                tfOutputFile = File.createTempFile("tempTerraformFile", ".tf", InputValidator.getTempDirPath().toFile());
                tfOutputFile.deleteOnExit();
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(tfOutputFile));){
                    writer.write(this.tfFilePath);
                }
                this.tfFilePath = tfOutputFile.getAbsolutePath();
                System.out.println("Temporary .tf file created at: " + this.tfFilePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating .tf file", e);
            }
        }
        boolean isAzureProvider = AzureHelper.isAzureTerraform(tfOutputFile);
        if (isAzureProvider && AzureHelper.isNotBlank(this.clientID) && AzureHelper.isNotBlank(this.secretKey) && AzureHelper.isNotBlank(this.tenantId)) {
            AzureHelper.injectAzureCredentials(tfOutputFile, this.clientID, this.secretKey, this.tenantId);
        }
        if (isAzureProvider) {
            AzureHelper.injectAzureVMAndNicNames(tfOutputFile, this.azureVMName);
        }
        AzureHelper.handleAzureSshKey(tfOutputFile, isAzureProvider, this.sshKey);
    }

    static void validateTfFile(String tfFile) {
        if (!tfFile.endsWith(".tf")) {
            throw new IllegalArgumentException("Please provide a file with correct extension(.tf). Invalid file provided: " + tfFile);
        }
    }

    static boolean isValidPathAndExists(String path) {
        try {
            return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
        }
        catch (NullPointerException | InvalidPathException e) {
            return false;
        }
    }

    private static Path getTempDirPath() {
        if (tempDir == null) {
            Path currentProcessDir = Paths.get(System.getProperty("user.dir"), new String[0]);
            String randomizedPath = "tf" + UUID.randomUUID().toString().substring(0, 8);
            tempDir = currentProcessDir.resolve(randomizedPath);
            try {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return tempDir;
    }

    public ArrayList<String> getTerraformCommand() {
        ArrayList<String> command = new ArrayList<String>();
        if (InputValidator.isWindows()) {
            command.add("cmd.exe");
            command.add(" ");
            command.add("/c");
            command.add(String.join((CharSequence)" ", this.tfCommandPath + TERRAFORM_WINDOWS));
        } else {
            command.add(this.tfCommandPath + TERRAFORM);
        }
        return command;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public File getTerraformFile() {
        return new File(this.tfFilePath);
    }

    static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public Operation getOperation() {
        return this.operation;
    }
}

