/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.AwsHelper;
import com.urbancode.air.plugin.command.AzureHelper;
import com.urbancode.air.plugin.command.GcpHelper;
import com.urbancode.air.plugin.command.InputValidator;
import com.urbancode.air.plugin.command.Operation;
import com.urbancode.air.plugin.command.ProcessHelper;
import com.urbancode.air.plugin.command.TerraformProviderIdentifier;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.IntStream;

public class RunTerraformFile {
    private final Properties inputProperties;
    private final Properties outputProperties;
    private InputValidator inputValidator;

    public RunTerraformFile(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        System.out.println("Validation ....");
        this.inputValidator = InputValidator.getValidatedInputs(this.inputProperties);
        GcpHelper helper = new GcpHelper(this.inputProperties);
        File filePath = this.inputValidator.getTerraformFile();
        AzureHelper azureHelper = new AzureHelper(this.inputProperties);
        TerraformProviderIdentifier.Provider provider = TerraformProviderIdentifier.findProvider(filePath);
        if (provider == TerraformProviderIdentifier.Provider.GOOGLE) {
            System.out.println("[GCP provider]");
            try {
                if (helper.hasCredentialsInScript(filePath)) {
                    System.out.println(" Credentials found in the script ");
                    this.runTerraformCommands(Optional.empty());
                } else {
                    System.out.println(" No Credentials found in the script, activating GCP service account ");
                    if (helper.validateGcpCred()) {
                        Map<String, String> gcpEnvProperties = helper.getActivateGcpServiceAccountKeyFile();
                        this.runTerraformCommands(Optional.of(gcpEnvProperties));
                    }
                }
                return 0;
            }
            catch (Exception e) {
                System.err.println("An error occurred during Terraform execution: " + e.getMessage());
                return 1;
            }
        }
        if (provider == TerraformProviderIdentifier.Provider.AZURE) {
            System.out.println("[Azure Provider]");
            try {
                azureHelper.validateSshPublicKey();
                azureHelper.validateAzureVMName();
                return this.runTerraformCommands(Optional.empty());
            }
            catch (Exception e) {
                System.err.println("An error occurred during Terraform execution: " + e.getMessage());
                return 1;
            }
        }
        System.out.println("[AWS Provider]");
        this.inputValidator.validateAwsRoleName();
        String sessionName = "AmSession18";
        System.out.println("Assuming role....");
        try {
            Map<String, String> awsEnvProperties = AwsHelper.assumeRole(this.inputValidator.getRoleArn(), sessionName);
            return this.runTerraformCommands(Optional.of(awsEnvProperties));
        }
        catch (Exception e) {
            System.err.println("An error occurred during Terraform execution: " + e.getMessage());
            return 1;
        }
    }

    int runTerraformCommands(Optional<Map<String, String>> envPropertiesForProcess) {
        ArrayList<String> tfCommandPath = new ArrayList<String>(this.inputValidator.getTerraformCommand());
        System.out.println("Initializing Terraform...");
        tfCommandPath.add("init");
        String tfDirectory = this.inputValidator.getTerraformFile().getParent();
        File[] files = new File(tfDirectory).listFiles();
        if (files == null || files.length == 0) {
            System.out.println("No files found in directory.");
        } else {
            System.out.println("Files in directory:");
            for (File f : files) {
                System.out.println(" - " + f.getName());
                if (!f.isFile() || !f.getName().endsWith(".tf")) continue;
                System.out.println("----- Terraform File Content: " + f.getName() + " -----");
                try {
                    if (f.length() == 0L) {
                        System.out.println("File is empty");
                    } else {
                        List<String> lines = Files.readAllLines(f.toPath(), StandardCharsets.UTF_8);
                        for (String line : lines) {
                            System.out.println(line);
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
                System.out.println("--------------------------------------------------------");
            }
        }
        ProcessHelper.runCommandsInAProcess(tfCommandPath.toArray(new String[0]), Optional.of(tfDirectory), envPropertiesForProcess);
        tfCommandPath.remove(tfCommandPath.size() - 1);
        tfCommandPath.add(this.inputValidator.getOperation().toString());
        Operation operation = this.inputValidator.getOperation();
        if (operation != Operation.PLAN) {
            tfCommandPath.add("-auto-approve");
        }
        System.out.println("Running Terraform command " + (Object)((Object)this.inputValidator.getOperation()));
        StringBuilder processOutput = ProcessHelper.runCommandsInAProcess(tfCommandPath.toArray(new String[0]), Optional.of(tfDirectory), envPropertiesForProcess);
        System.out.println("Terraform execution completed successfully.");
        return 0;
    }

    private void setOutputProps(String line) {
        String[] opVars = line.split("\\s+");
        System.out.println("Length of outputVars " + opVars.length);
        IntStream.range(0, opVars.length).forEach(i -> System.out.println(i + ". " + opVars[i]));
        this.outputProperties.setProperty("add", opVars[1]);
        this.outputProperties.setProperty("change", opVars[4]);
        this.outputProperties.setProperty("destroy", opVars[7]);
    }
}

