/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class TerraformProviderIdentifier {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Provider findProvider(File tfFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(tfFile));){
            block27: {
                String line;
                while ((line = br.readLine()) != null) {
                    String trimmedLine = line.trim().toLowerCase();
                    if (!trimmedLine.startsWith("provider")) continue;
                    if (trimmedLine.contains("\"google\"")) {
                        Provider provider = Provider.GOOGLE;
                        return provider;
                    }
                    if (trimmedLine.contains("\"azurerm\"")) {
                        Provider provider = Provider.AZURE;
                        return provider;
                    }
                    if (!trimmedLine.contains("\"aws\"")) {
                        continue;
                    }
                    break block27;
                }
                return Provider.AWS;
            }
            Provider provider = Provider.AWS;
            return provider;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to determine Terraform provider from the file: " + tfFile.getAbsolutePath(), e);
        }
    }

    static enum Provider {
        GOOGLE,
        AWS,
        AZURE;

    }
}

