/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.PermissionReader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BestEffortPermissionReader
extends PermissionReader {
    private static final Logger log = Logger.getLogger(BestEffortPermissionReader.class);
    private final PermissionReader delegate;

    BestEffortPermissionReader(PermissionReader delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
    }

    @Override
    Set<?> getPermissions(File file) throws IOException {
        try {
            return this.delegate.getPermissions(file);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Non-fatal error reading permission for " + file), (Throwable)e);
            }
            return Collections.emptySet();
        }
    }
}

