/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import java.io.Serializable;
import java.util.Date;

public final class FileTime
implements Comparable<FileTime>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long JAVA_EPOCH_IN_TICKS = 116444736000000000L;
    private static final long TICKS_PER_MILLI = 10000L;
    private final long ticks;

    public FileTime(Date date) {
        this(date.getTime() * 10000L + 116444736000000000L);
    }

    public FileTime(long ticks) {
        this.ticks = ticks;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileTime) {
            FileTime rhs = (FileTime)obj;
            return this.ticks == rhs.ticks;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.ticks ^ this.ticks >>> 32);
    }

    public String toString() {
        return this.toDate().toString();
    }

    @Override
    public int compareTo(FileTime rhs) {
        if (rhs == null) {
            throw new NullPointerException();
        }
        return this.ticks < rhs.ticks ? -1 : (this.ticks == rhs.ticks ? 0 : 1);
    }

    public long getTicks() {
        return this.ticks;
    }

    public Date toDate() {
        long millis = (this.ticks - 116444736000000000L) / 10000L;
        return new Date(millis);
    }
}

