#!/usr/bin/env groovy

import com.urbancode.air.CommandHelper


final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def packageName = props['packageName']
final def packageVersion = props['packageVersion']
final def packageType = props['packageType']
final def outputDir = new File(props['outputDirectory'])
final def contentDir = new File(props['contentDirectory'])
final def dependencies = props["dependencies"]
final def PACKAGER_HOME = new File(props['packagerHome'])
final def packagerBin = new File(PACKAGER_HOME, 'bin')
final def packagerExe = new File(packagerBin, "packageCreator" + (isWindows ? ".cmd" : ".sh"))

//------------------------------------------------------------------------------
// Create a template directory with properties and environment file
//------------------------------------------------------------------------------
final def tmpdir = new File(System.getProperty("java.io.tmpdir"))
final def templateDir = new File(tmpdir, "uc-pkg-tmp-" + new Random().nextInt())
final def propertiesFile = new File(templateDir, "properties")
final def dependenciesFile = new File(templateDir, "dependencies")

templateDir.mkdirs()

// Write Properties to file.
final def properties = new Properties()
properties.setProperty("Name", packageName)
properties.setProperty("Version", packageVersion)
properties.setProperty("Type", packageType)
properties.store(new FileOutputStream(propertiesFile), null as String)

// Write dependencies to file.
dependenciesFile << dependencies

//------------------------------------------------------------------------------
// PREPARE COMMAND LINE
//------------------------------------------------------------------------------
  
def command = [packagerExe.absolutePath]

command << outputDir.absolutePath
command << contentDir.absolutePath
command << "-t"
command << templateDir.absolutePath

//------------------------------------------------------------------------------
// EXECUTE COMMAND LINE
//------------------------------------------------------------------------------

def ch = new CommandHelper(packagerBin);
ch.runCommand("Creating Package", command);
