#!/usr/bin/env groovy

import com.urbancode.air.CommandHelper


final def isWindows = (System.getProperty("os.name") =~ /(?i)windows/).find()
final def workDir = new File(".").canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def packageName = new File(props["packageName"])
final def PACKAGER_HOME = new File(props["packagerHome"])
final def verifyProperties = props["verifyProperties"]
final def skipDependencyCheckBool = Boolean.valueOf(props["skipDependencyCheck"])
final def impersonateUser = props["impersonateUser"]
final def impersonatePass = props["impersonatePass"]
final def inventoryName = props["inventory"]

final def verifyPropertiesArray = verifyProperties?.readLines()?.toArray(new String[0])

final def packagerBin = new File(PACKAGER_HOME, "bin")
final def packagerExe = new File(packagerBin, "packager" + (isWindows ? ".cmd" : ".sh")) 

//------------------------------------------------------------------------------
// PREPARE COMMAND LINE
//------------------------------------------------------------------------------
  
def command = [packagerExe.absolutePath, "verify", packageName]

if (skipDependencyCheckBool) {
    command << "-d"
}
if (impersonateUser != null && impersonateUser.length() > 0) {
    command << "-u" + impersonateUser
}
if (impersonatePass != null && impersonatePass.length() > 0) {
    command << "-p" + impersonatePass
}
if (inventoryName != null && inventoryName.length() > 0) {
    command << "-i" + inventoryName
}

verifyPropertiesArray.each() { verifyProperty ->
    command << verifyProperty
}

//------------------------------------------------------------------------------
// EXECUTE COMMAND LINE
//------------------------------------------------------------------------------

def ch = new CommandHelper(packagerBin);
ch.runCommand("Verifying installation", command);
