/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.asm;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

class Mutation {
    private final UUID id;
    private final UUID originatorId;
    private final Op op;
    private final UUID asid;
    private final UUID expected;
    private final UUID update;

    static Mutation fromBytes(byte[] bytes) throws IOException {
        String json = new String(bytes, "UTF-8");
        try {
            return Mutation.fromJSON(json);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    static Mutation fromJSON(String json) throws JSONException {
        JSONObject jobj = new JSONObject(json);
        if (!jobj.has("id")) {
            throw new JSONException("Missing 'id' property");
        }
        if (!jobj.has("originatorId")) {
            throw new JSONException("Missing 'originatorId' property");
        }
        if (!jobj.has("op")) {
            throw new JSONException("Missing 'op' property");
        }
        if (!jobj.has("asid")) {
            throw new JSONException("Missing 'asid' property");
        }
        UUID id = Mutation.toUUID("id", jobj.getString("id"));
        UUID peerId = Mutation.toUUID("originatorId", jobj.getString("originatorId"));
        Op op = Mutation.toOp("op", jobj.getString("op"));
        UUID asid = Mutation.toUUID("asid", jobj.getString("asid"));
        UUID expected = null;
        if (jobj.has("expected")) {
            expected = Mutation.toUUID("expected", jobj.getString("expected"));
        }
        UUID update = null;
        if (jobj.has("update")) {
            update = Mutation.toUUID("update", jobj.getString("update"));
        }
        try {
            return new Mutation(id, peerId, op, asid, expected, update);
        }
        catch (NullPointerException e) {
            throw (JSONException)new JSONException("Mising property '" + e.getMessage() + "' required by op '" + (Object)((Object)op) + "'").initCause((Throwable)e);
        }
    }

    static Mutation compareAndSet(UUID asid, UUID originatorId, UUID expected, UUID update) {
        UUID id = UUID.randomUUID();
        return new Mutation(id, originatorId, Op.COMPARE_AND_SET, asid, expected, update);
    }

    static Mutation compareAndRemove(UUID asid, UUID originatorId, UUID expected) {
        UUID id = UUID.randomUUID();
        return new Mutation(id, originatorId, Op.COMPARE_AND_REMOVE, asid, expected, null);
    }

    static Mutation set(UUID asid, UUID originatorId, UUID update) {
        UUID id = UUID.randomUUID();
        return new Mutation(id, originatorId, Op.SET, asid, null, update);
    }

    static Mutation remove(UUID asid, UUID originatorId) {
        UUID id = UUID.randomUUID();
        return new Mutation(id, originatorId, Op.REMOVE, asid, null, null);
    }

    private static UUID toUUID(String prop, String s) throws JSONException {
        if (s == null) {
            return null;
        }
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException e) {
            throw (JSONException)new JSONException("Invalid ID in '" + prop + "': " + s).initCause((Throwable)e);
        }
    }

    private static Op toOp(String prop, String s) throws JSONException {
        if (s == null) {
            return null;
        }
        try {
            return Op.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw (JSONException)new JSONException("Invalid Op in '" + prop + "': " + s).initCause((Throwable)e);
        }
    }

    Mutation(UUID id, UUID originatorId, Op op, UUID asid, UUID expected, UUID update) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (originatorId == null) {
            throw new NullPointerException("originatorId");
        }
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (asid == null) {
            throw new NullPointerException("asid");
        }
        switch (op) {
            case COMPARE_AND_SET: {
                if (update != null) break;
                throw new NullPointerException("update");
            }
            case COMPARE_AND_REMOVE: {
                if (expected != null) break;
                throw new NullPointerException("expected");
            }
            case SET: {
                if (update != null) break;
                throw new NullPointerException("update");
            }
        }
        this.id = id;
        this.originatorId = originatorId;
        this.op = op;
        this.asid = asid;
        this.expected = expected;
        this.update = update;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getOriginatorId() {
        return this.originatorId;
    }

    public Op getOp() {
        return this.op;
    }

    public UUID getAsid() {
        return this.asid;
    }

    public UUID getExpected() {
        return this.expected;
    }

    public UUID getUpdate() {
        return this.update;
    }

    String toJSON() {
        try {
            JSONObject jobj = new JSONObject();
            jobj.put("id", (Object)this.id.toString());
            jobj.put("originatorId", (Object)this.originatorId.toString());
            jobj.put("op", (Object)this.op.toString());
            jobj.put("asid", (Object)this.asid.toString());
            if (this.expected != null) {
                jobj.put("expected", (Object)this.expected.toString());
            }
            if (this.update != null) {
                jobj.put("update", (Object)this.update.toString());
            }
            return jobj.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    byte[] toBytes() {
        try {
            return this.toJSON().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static enum Op {
        COMPARE_AND_SET,
        COMPARE_AND_REMOVE,
        SET,
        REMOVE;

    }
}

