/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client;

import com.ibm.uclab.csrepl.client.ArtifactSetBuilderClientData;
import com.ibm.uclab.csrepl.client.ArtifactSetBuilderClientMeta;
import com.ibm.uclab.csrepl.client.CallResult;
import com.ibm.uclab.csrepl.codestation.ArtifactSetBuilder;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReaders;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.Filter;
import com.ibm.uclab.csrepl.http.HttpClientWrapper;
import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import com.ibm.uclab.csrepl.streams.AbortingInputStream;
import com.ibm.uclab.csrepl.streams.HashCheckingInputStream;
import com.ibm.uclab.csrepl.streams.HashInjectingInputStream;
import com.urbancode.commons.util.IO;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

public class CodestationClient {
    static final String DIGEST_HEADER = "X-Codestation-Digest-Algorithm";
    static final String CS_URL_SUFFIX = "/codestation/v1";
    static final String ARITFACTS_URL_SUFFIX = "/artifacts";
    private static final Logger log = Logger.getLogger(CodestationClient.class);
    private final String url;
    private final String serviceUrl;
    private final HttpClientWrapper wrapper;
    private final Lifecycle lifecycle;
    private HttpClient client;

    static FileNotFoundException notFound(UUID artifactSetId, CallResult result) {
        String error = CodestationClient.getErrorMessage(result.res);
        error = error == null ? "" : ": " + error;
        StatusLine status = result.res.getStatusLine();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Request failed with not found: %s %s: %03d %s%s", result.method, result.reqUrl, status.getStatusCode(), status.getReasonPhrase(), error));
        }
        return new FileNotFoundException(String.format("Artifact set not found: %s%n%s URL: %s", artifactSetId, result.method, result.reqUrl));
    }

    static IOException unacceptableResponse(CallResult result) {
        String error = CodestationClient.getErrorMessage(result.res);
        error = error == null ? "" : ": " + error;
        StatusLine status = result.res.getStatusLine();
        String message = String.format("Unacceptable response: %s %s: %03d %s%s", result.method, result.reqUrl, status.getStatusCode(), status.getReasonPhrase(), error);
        log.debug((Object)message);
        return new IOException(message);
    }

    private static String getErrorMessage(HttpResponse res) {
        try {
            HttpEntity ent = res.getEntity();
            if (ent == null) {
                return null;
            }
            Header hd = ent.getContentType();
            if (hd == null) {
                return null;
            }
            String val = hd.getValue();
            if (val == null) {
                return null;
            }
            ContentType ct = ContentType.parse((String)val);
            if (ct == null) {
                return null;
            }
            if (!"text/plain".equalsIgnoreCase(ct.getMimeType())) {
                return null;
            }
            return EntityUtils.toString((HttpEntity)ent);
        }
        catch (ParseException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public CodestationClient(String url, HttpClientWrapper wrapper) {
        this.url = url;
        this.serviceUrl = this.sanitizeUrl(url) + CS_URL_SUFFIX + ARITFACTS_URL_SUFFIX;
        this.wrapper = wrapper;
        this.lifecycle = new Lifecycle(this, new LifecycleEventListener(){

            @Override
            public void onStart() {
                CodestationClient.this.start0();
            }

            @Override
            public void onStop() {
                CodestationClient.this.stop0();
            }
        });
    }

    public String getUrl() {
        return this.url;
    }

    public void start() {
        this.lifecycle.start();
    }

    public void stop() {
        this.lifecycle.stop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<FileMetadata> getMetadata(UUID artifactSetId, Filter filter) throws IOException {
        this.lifecycle.checkActive();
        if (artifactSetId == null) {
            throw new NullPointerException("artifactSetId");
        }
        String reqUrl = String.format("%s/%s/meta", this.serviceUrl, artifactSetId);
        CallResult result = this.callHttp(reqUrl, filter);
        StatusLine status = result.res.getStatusLine();
        switch (status.getStatusCode()) {
            case 200: {
                MessageDigest dig;
                HttpEntity ent = result.res.getEntity();
                InputStream in = null;
                Charset cs = null;
                if (ent != null) {
                    in = ent.getContent();
                    cs = this.getCharset(ent);
                }
                if (ent == null || in == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Request succeeded without content: %s: %03d %s", reqUrl, status.getStatusCode(), status.getReasonPhrase()));
                    }
                    ArrayList<FileMetadata> arrayList = new ArrayList<FileMetadata>();
                    return arrayList;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Request succeeded with content: %s: %03d %s", reqUrl, status.getStatusCode(), status.getReasonPhrase()));
                }
                if ((dig = this.getResponseDigest(result.res)) != null) {
                    in = new HashCheckingInputStream(in, dig);
                }
                String json = IO.readText((InputStream)in, (Charset)cs);
                try {
                    List<FileMetadata> list = this.getMeta(json);
                    return list;
                }
                catch (JSONException e) {
                    if (!log.isDebugEnabled()) throw new IOException("Invalid JSON: " + e.getMessage(), e);
                    log.debug((Object)String.format("Request succeeded but with invalid JSON: %s: %03d %s", reqUrl, status.getStatusCode(), status.getReasonPhrase()));
                    log.debug((Object)("Received content: " + json));
                    throw new IOException("Invalid JSON: " + e.getMessage(), e);
                }
            }
            case 404: {
                throw CodestationClient.notFound(artifactSetId, result);
            }
        }
        throw CodestationClient.unacceptableResponse(result);
        finally {
            EntityUtils.consumeQuietly((HttpEntity)result.res.getEntity());
        }
    }

    public ArtifactSetReader openArtifactSet(UUID artifactSetId, Filter filter) throws IOException {
        this.lifecycle.checkActive();
        if (artifactSetId == null) {
            throw new NullPointerException("artifactSetId");
        }
        String reqUrl = String.format("%s/%s", this.serviceUrl, artifactSetId);
        boolean consumeEntity = true;
        CallResult result = this.callHttp(reqUrl, filter);
        try {
            StatusLine status = result.res.getStatusLine();
            switch (status.getStatusCode()) {
                case 200: {
                    HttpEntity ent = result.res.getEntity();
                    InputStream in = null;
                    String boundary = null;
                    if (ent != null) {
                        in = ent.getContent();
                        boundary = this.getBoundary(ent);
                    }
                    if (ent == null || in == null || boundary == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Request succeeded without content: %s: %03d %s", reqUrl, status.getStatusCode(), status.getReasonPhrase()));
                        }
                        ArtifactSetReader artifactSetReader = ArtifactSetReaders.empty();
                        return artifactSetReader;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Request succeeded with content: %s: %03d %s", reqUrl, status.getStatusCode(), status.getReasonPhrase()));
                    }
                    in = new AbortingInputStream(result.req, in);
                    MessageDigest dig = this.getResponseDigest(result.res);
                    if (dig != null) {
                        in = new HashCheckingInputStream(in, dig);
                    }
                    consumeEntity = false;
                    ArtifactSetReader artifactSetReader = ArtifactSetReaders.fromMultipart(in, boundary);
                    return artifactSetReader;
                }
                case 404: {
                    throw CodestationClient.notFound(artifactSetId, result);
                }
            }
            throw CodestationClient.unacceptableResponse(result);
        }
        finally {
            if (consumeEntity) {
                EntityUtils.consumeQuietly((HttpEntity)result.res.getEntity());
            }
        }
    }

    public ArtifactSetBuilder createBuilder(UUID artifactSetId) throws IOException {
        this.lifecycle.checkActive();
        if (artifactSetId == null) {
            throw new NullPointerException("artifactSetId");
        }
        return new ArtifactSetBuilderClientData(artifactSetId, this.getClient(), this.serviceUrl);
    }

    public ArtifactSetBuilder createMetadataOnlyBuilder(UUID artifactSetId) throws IOException {
        this.lifecycle.checkActive();
        if (artifactSetId == null) {
            throw new NullPointerException("artifactSetId");
        }
        return new ArtifactSetBuilderClientMeta(artifactSetId, this.getClient(), this.serviceUrl);
    }

    private synchronized HttpClient getClient() {
        if (this.client == null) {
            this.wrapper.start();
            this.client = this.wrapper.getClient();
        }
        return this.client;
    }

    private String sanitizeUrl(String url) {
        if ((url = this.removeTrailingSlashes(url)).endsWith(ARITFACTS_URL_SUFFIX)) {
            url = url.substring(0, url.length() - ARITFACTS_URL_SUFFIX.length());
        }
        if (url.endsWith(CS_URL_SUFFIX)) {
            url = url.substring(0, url.length() - CS_URL_SUFFIX.length());
        }
        url = this.removeTrailingSlashes(url);
        return url;
    }

    private String removeTrailingSlashes(String url) {
        for (int i = url.length() - 1; i >= 0; --i) {
            if (url.charAt(i) == '/') continue;
            url = url.substring(0, i + 1);
            break;
        }
        return url;
    }

    private CallResult callHttp(String url, Filter filter) throws IOException {
        HttpClient client = this.getClient();
        MessageDigest dig = IO.md5Digester();
        if (filter == null) {
            HttpGet req = new HttpGet(url);
            req.setHeader(DIGEST_HEADER, dig.getAlgorithm());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing: GET " + req.getURI()));
            }
            return new CallResult("GET", url, (HttpRequestBase)req, client.execute((HttpUriRequest)req));
        }
        HttpPost req = new HttpPost(url);
        byte[] content = filter.toJSON().toString().getBytes(IO.utf8());
        ContentType ct = ContentType.create((String)"application/json", (Charset)IO.utf8());
        HashInjectingInputStream in = new HashInjectingInputStream(new ByteArrayInputStream(content), dig);
        req.setHeader(DIGEST_HEADER, dig.getAlgorithm());
        req.setEntity((HttpEntity)new InputStreamEntity((InputStream)in, -1L, ct));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing: POST " + req.getURI()));
            log.debug((Object)("Includes: " + filter.getIncludes()));
            log.debug((Object)("Excludes: " + filter.getExcludes()));
        }
        return new CallResult("POST", url, (HttpRequestBase)req, client.execute((HttpUriRequest)req));
    }

    private MessageDigest getResponseDigest(HttpResponse res) throws IOException {
        Header h = res.getFirstHeader(DIGEST_HEADER);
        if (h == null) {
            return null;
        }
        String v = h.getValue();
        if (v == null) {
            return null;
        }
        try {
            return MessageDigest.getInstance(v);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unsupported digest: " + v);
        }
    }

    private Charset getCharset(HttpEntity ent) {
        Header ct = ent.getContentType();
        if (ct == null) {
            return IO.utf8();
        }
        HeaderElement[] els = ct.getElements();
        if (els == null || els.length == 0) {
            return IO.utf8();
        }
        NameValuePair nv = els[0].getParameterByName("charset");
        if (nv == null) {
            return IO.utf8();
        }
        String v = nv.getValue();
        if (v == null) {
            return IO.utf8();
        }
        return Charset.forName(v);
    }

    private String getBoundary(HttpEntity ent) {
        Header ct = ent.getContentType();
        if (ct == null) {
            return null;
        }
        String val = ct.getValue();
        if (val == null) {
            return null;
        }
        if (!val.toLowerCase(Locale.US).startsWith("multipart/")) {
            return null;
        }
        HeaderElement[] els = ct.getElements();
        if (els == null || els.length == 0) {
            return null;
        }
        NameValuePair nv = els[0].getParameterByName("boundary");
        if (nv == null) {
            return null;
        }
        return nv.getValue();
    }

    private List<FileMetadata> getMeta(String json) throws JSONException {
        ArrayList<FileMetadata> meta = new ArrayList<FileMetadata>();
        JSONArray array = new JSONArray(json);
        for (int i = 0; i < array.length(); ++i) {
            meta.add(FileMetadata.fromJSON(array.getJSONObject(i)));
        }
        return meta;
    }

    private void start0() {
        this.wrapper.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        this.wrapper.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }
}

