/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.streams;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class HashInjectingInputStream
extends InputStream {
    private final InputStream in;
    private final MessageDigest dig;
    private byte[] hash;
    private int hashPos;
    private volatile boolean aborted;

    public HashInjectingInputStream(InputStream in, MessageDigest dig) {
        this.in = in;
        this.dig = dig;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.hash != null) {
            return this.readHash();
        }
        int b = this.read0();
        if (b < 0) {
            this.hash = this.dig.digest();
            return this.readHash();
        }
        this.dig.update((byte)b);
        return b;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        if (this.hash != null) {
            return this.readHash(b, off, len);
        }
        int n = this.read0(b, off, len);
        if (n < 0) {
            this.hash = this.dig.digest();
            return this.readHash(b, off, len);
        }
        this.dig.update(b, off, n);
        return n;
    }

    public void abort() throws IOException {
        this.aborted = true;
        this.in.close();
    }

    @Override
    public synchronized void close() throws IOException {
        this.hash = null;
        this.in.close();
    }

    private int readHash() {
        if (this.hashPos >= this.hash.length) {
            return -1;
        }
        return this.hash[this.hashPos++] & 0xFF;
    }

    private int readHash(byte[] b, int off, int len) throws IOException {
        if (this.aborted) {
            this.hash = null;
            return -1;
        }
        if (this.hashPos >= this.hash.length) {
            return -1;
        }
        int n = Math.min(this.hash.length - this.hashPos, len);
        System.arraycopy(this.hash, this.hashPos, b, off, n);
        this.hashPos += n;
        return n;
    }

    private int read0() throws IOException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            if (this.aborted) {
                return -1;
            }
            throw e;
        }
    }

    private int read0(byte[] b, int off, int len) throws IOException {
        try {
            return this.in.read(b, off, len);
        }
        catch (IOException e) {
            if (this.aborted) {
                return -1;
            }
            throw e;
        }
    }
}

