/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.CodestationService;
import com.ibm.uclab.csrepl.codestation.CodestationServiceLookup;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.exceptions.AuthenticationException;
import com.ibm.uclab.csrepl.exceptions.CorruptStreamException;
import com.ibm.uclab.csrepl.rest.DigestParam;
import com.ibm.uclab.csrepl.rest.Errors;
import com.ibm.uclab.csrepl.rest.KeysParam;
import com.ibm.uclab.csrepl.rest.MediaTypeParam;
import com.ibm.uclab.csrepl.rest.MetaFilter;
import com.ibm.uclab.csrepl.rest.MetaFilterParser;
import com.ibm.uclab.csrepl.rest.UUIDParam;
import com.ibm.uclab.csrepl.streams.ArtifactSetReaderInputStream;
import com.ibm.uclab.csrepl.streams.HashCheckingInputStream;
import com.ibm.uclab.csrepl.streams.HashInjectingInputStream;
import com.urbancode.commons.util.IO;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;

@Path(value="artifacts")
public class ArtifactsResource {
    private static final Logger log = Logger.getLogger(ArtifactsResource.class);
    private static final AtomicLong counter = new AtomicLong();
    private static final String MULTIPART_MIXED = "multipart/mixed";
    private static final MediaType jsonType = new MediaType(MediaType.APPLICATION_JSON_TYPE.getType(), MediaType.APPLICATION_JSON_TYPE.getSubtype(), Collections.singletonMap("charset", IO.utf8().name()));
    private final CodestationService cs;

    public ArtifactsResource() {
        this(CodestationServiceLookup.get());
    }

    public ArtifactsResource(@Context CodestationService cs) {
        this.cs = cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public String getStatus() {
        String string;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../artifacts/status", op));
        }
        try {
            this.getCS();
            string = "OK";
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{artifactSetId}/meta")
    public Response getMeta(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @QueryParam(value="keys") KeysParam keys) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../artifacts/%s/meta", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
            log.trace((Object)String.format("[op=%d] Param: %s=%s", op, "keys", keys));
        }
        try {
            response = this.doGetMeta(artifactSetId.getUUID(), DigestParam.toDigest(digest), MetaFilter.fromKeysParam(keys));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{artifactSetId}/meta")
    @Consumes(value={"application/json"})
    public Response getMeta(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Content-Type") MediaTypeParam type, InputStream filterJson) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] POST .../artifacts/%s/meta", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "Content-Type", type));
        }
        try {
            UUID asid = artifactSetId.getUUID();
            MessageDigest dig = DigestParam.toDigest(digest);
            MetaFilter filter = MetaFilter.getDefaultFilter();
            if (filterJson != null) {
                if (dig != null) {
                    filterJson = new HashCheckingInputStream(filterJson, dig);
                }
                filter = new MetaFilterParser(filterJson, MediaTypeParam.toType(type)).getFilter();
            }
            response = this.doGetMeta(asid, dig, filter);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{artifactSetId}")
    public Response getData(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../artifacts/%s", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
        }
        try {
            response = this.doGetData(artifactSetId, digest, new MediaTypeParam(), null);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{artifactSetId}")
    @Consumes(value={"application/json"})
    public Response getData(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Content-Type") MediaTypeParam type, InputStream filterJson) throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] POST .../artifacts/%s", op, artifactSetId));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "X-Codestation-Digest-Algorithm", digest));
            log.trace((Object)String.format("[op=%d] Header: %s=%s", op, "Content-Type", type));
        }
        try {
            response = this.doGetData(artifactSetId, digest, type, filterJson);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="{artifactSetId}/meta/update")
    @Consumes(value={"application/json"})
    public Response updateMeta(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Content-Type") MediaTypeParam type, InputStream metaJson) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="{artifactSetId}/update")
    @Consumes(value={"multipart/mixed"})
    public Response updateData(@PathParam(value="artifactSetId") UUIDParam artifactSetId, @HeaderParam(value="X-Codestation-Digest-Algorithm") DigestParam digest, @HeaderParam(value="Content-Type") MediaTypeParam type, InputStream dataMultipart) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CodestationService getCS() {
        if (this.cs == null) {
            throw Errors.serviceUnavailable("Artifacts service unavailable");
        }
        return this.cs;
    }

    private Response doGetData(UUIDParam artifactSetId, DigestParam digest, MediaTypeParam type, InputStream filterJson) throws IOException {
        CodestationService cs = this.getCS();
        UUID asid = artifactSetId.getUUID();
        MessageDigest dig = null;
        if (digest != null && (dig = digest.getDigest()) != null && filterJson != null) {
            filterJson = new HashCheckingInputStream(filterJson, dig);
        }
        try {
            ArtifactSetReaderInputStream in;
            MetaFilter filter = new MetaFilterParser(filterJson, type.getType()).getFilter();
            ArtifactSetReader reader = cs.openArtifactSet(asid, filter.getFileFilter());
            InputStream resIn = in = new ArtifactSetReaderInputStream(reader);
            if (dig != null) {
                resIn = new HashInjectingInputStream(resIn, dig);
            }
            MediaType resType = this.getMultipartType(in.getBoundary());
            Response.ResponseBuilder resb = Response.ok((Object)resIn, (MediaType)resType);
            resb.header("X-Codestation-Artifact-Set-ID", (Object)asid.toString());
            if (dig != null) {
                resb.header("X-Codestation-Digest-Algorithm", (Object)dig.getAlgorithm());
            }
            return resb.build();
        }
        catch (AuthenticationException e) {
            throw Errors.unauthorized("Cannot authenticate with peer: " + e.getMessage(), e);
        }
        catch (CorruptStreamException e) {
            throw Errors.badRequest("Transfer aborted: " + e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            throw Errors.notFound("Artifact set not found: " + asid, e);
        }
        catch (UnsupportedOperationException e) {
            throw Errors.forbidden("Unsupported operation: " + e.getMessage(), e);
        }
    }

    private MediaType getMultipartType(String boundary) {
        return new MediaType("multipart", "mixed", Collections.singletonMap("boundary", boundary));
    }

    private String getBoundary(MediaType type) {
        if (type == null) {
            return null;
        }
        return (String)type.getParameters().get("boundary");
    }

    private Response doGetMeta(UUID asid, MessageDigest digest, MetaFilter filter) throws Exception {
        CodestationService cs = this.getCS();
        try {
            List<FileMetadata> meta = cs.getMetadata(asid, filter.getFileFilter());
            JSONArray jarray = new JSONArray();
            for (FileMetadata m : meta) {
                jarray.put((Object)m.toJSON(filter.getKeys()));
            }
            InputStream resIn = new ByteArrayInputStream(jarray.toString().getBytes(IO.utf8()));
            if (digest != null) {
                resIn = new HashInjectingInputStream(resIn, digest);
            }
            Response.ResponseBuilder resb = Response.ok((Object)resIn, (MediaType)jsonType);
            resb.header("X-Codestation-Artifact-Set-ID", (Object)asid.toString());
            if (digest != null) {
                resb.header("X-Codestation-Digest-Algorithm", (Object)digest.getAlgorithm());
            }
            return resb.build();
        }
        catch (AuthenticationException e) {
            throw Errors.unauthorized("Cannot authenticate with peer: " + e.getMessage(), e);
        }
        catch (CorruptStreamException e) {
            throw Errors.badRequest("Transfer aborted: " + e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            throw Errors.notFound("Artifact set not found: " + asid, e);
        }
        catch (UnsupportedOperationException e) {
            throw Errors.forbidden("Unsupported operation: " + e.getMessage(), e);
        }
    }
}

