/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import java.io.IOException;
import java.util.Arrays;

class AggregateInputStreamZero
extends AggregateInputStream {
    private final AggregateItem item;
    private long pos;

    public AggregateInputStreamZero(AggregateItem item) {
        this.item = item;
    }

    public AggregateItem getItem() {
        return this.item;
    }

    public synchronized int read() throws IOException {
        this.checkOpen();
        if (this.pos >= this.item.getLength()) {
            return -1;
        }
        ++this.pos;
        return 0;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        this.checkOpen();
        if (this.pos >= this.item.getLength()) {
            return -1;
        }
        int n = (int)Math.min(this.item.getLength() - this.pos, (long)len);
        Arrays.fill(b, off, off + n, (byte)0);
        this.pos += (long)n;
        return n;
    }

    public synchronized int available() throws IOException {
        this.checkOpen();
        if (this.pos >= this.item.getLength()) {
            return 0;
        }
        return (int)Math.min(this.item.getLength() - this.pos, Integer.MAX_VALUE);
    }

    public synchronized long skip(long n) throws IOException {
        this.checkOpen();
        if (this.pos >= this.item.getLength()) {
            return 0L;
        }
        n = Math.min(this.item.getLength() - this.pos, n);
        this.pos += n;
        return n;
    }

    public synchronized void close() throws IOException {
        this.pos = -1L;
    }

    private void checkOpen() throws IOException {
        if (this.pos == -1L) {
            throw new IOException("Stream closed");
        }
    }
}

