/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.codestation;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.codestation.ArtifactSetBuilder;
import com.ibm.uclab.csrepl.codestation.ArtifactSetBuilderImpl;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReaderImpl;
import com.ibm.uclab.csrepl.codestation.CodestationInputStream;
import com.ibm.uclab.csrepl.codestation.CodestationService;
import com.ibm.uclab.csrepl.codestation.CodestationServiceImplAddToZip;
import com.ibm.uclab.csrepl.codestation.CodestationServiceImplGetMetadata;
import com.ibm.uclab.csrepl.codestation.CodestationServiceImplIsMetadataOnly;
import com.ibm.uclab.csrepl.codestation.CodestationServiceImplOpenFile;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.codestation.Filter;
import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.log4j.Logger;

public class CodestationServiceImpl
implements CodestationService {
    private static final Logger log = Logger.getLogger(CodestationServiceImpl.class);
    private final ArtifactSetManager asm;
    private final BlobManager bm;
    private final File stageDir;
    private final Lifecycle lifecycle;

    public CodestationServiceImpl(ArtifactSetManager asm, BlobManager bm, File stageDir) {
        if (stageDir != null) {
            stageDir = stageDir.getAbsoluteFile();
        }
        this.lifecycle = new Lifecycle(this, new LifecycleEventListener(){

            @Override
            public void onStart() {
                CodestationServiceImpl.this.start0();
            }

            @Override
            public void onStop() {
                CodestationServiceImpl.this.stop0();
            }
        });
        this.asm = asm;
        this.bm = bm;
        this.stageDir = stageDir;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void start() {
        this.lifecycle.start();
    }

    @Override
    public void stop() {
        this.lifecycle.stop();
    }

    @Override
    public CodestationInputStream openFile(UUID artifactSetId, String path) throws IOException {
        this.lifecycle.checkActive();
        return new CodestationServiceImplOpenFile(this.asm, this.bm, artifactSetId, path).run();
    }

    @Override
    public ArtifactSetReader openArtifactSet(UUID artifactSetId, Filter filter) throws IOException {
        this.lifecycle.checkActive();
        return new ArtifactSetReaderImpl(this.asm, this.bm, artifactSetId, filter);
    }

    @Override
    public void addToZip(UUID artifactSetId, ZipArchiveOutputStream zip, String pathPrefix) throws IOException {
        this.lifecycle.checkActive();
        new CodestationServiceImplAddToZip(this.asm, this.bm, artifactSetId, zip, pathPrefix).run();
    }

    @Override
    public List<FileMetadata> getMetadata(UUID artifactSetId, Filter filter) throws IOException {
        this.lifecycle.checkActive();
        return new CodestationServiceImplGetMetadata(this.asm, this.bm, artifactSetId, filter).run();
    }

    @Override
    public void deleteArtifactSet(UUID artifactSetId) throws IOException {
        this.lifecycle.checkActive();
        this.asm.removeBlobId(artifactSetId);
    }

    @Override
    public ArtifactSetBuilder createBuilder(UUID artifactSetId) throws IOException {
        this.lifecycle.checkActive();
        if (this.stageDir == null) {
            throw new UnsupportedOperationException("Local creation disabled");
        }
        File tempDir = new File(this.stageDir, UUID.randomUUID().toString()).getAbsoluteFile();
        return new ArtifactSetBuilderImpl(this.asm, this.bm, artifactSetId, tempDir, false);
    }

    @Override
    public boolean isMetadataOnly(UUID artifactSetId) throws IOException {
        this.lifecycle.checkActive();
        return new CodestationServiceImplIsMetadataOnly(this.asm, this.bm, artifactSetId).run();
    }

    @Override
    public ArtifactSetBuilder createMetadataOnlyBuilder(UUID artifactSetId) throws IOException {
        this.lifecycle.checkActive();
        if (this.stageDir == null) {
            throw new UnsupportedOperationException("Local creation disabled");
        }
        File tempDir = new File(this.stageDir, UUID.randomUUID().toString()).getAbsoluteFile();
        return new ArtifactSetBuilderImpl(this.asm, this.bm, artifactSetId, tempDir, true);
    }

    @Override
    public long estimateDiskUsage(UUID artifactSetId) throws IOException {
        this.lifecycle.checkActive();
        long size = this.asm.estimateDiskUsage(artifactSetId);
        if (size == -1L) {
            size = 0L;
        }
        return size;
    }

    @Override
    public Set<String> getGeoTags(UUID artifactSetId) throws IOException {
        this.lifecycle.checkActive();
        return this.asm.getGeoTags(artifactSetId);
    }

    @Override
    public void setGeoTags(UUID artifactSetId, Collection<String> geoTags) throws IOException {
        this.lifecycle.checkActive();
        this.asm.setGeoTags(artifactSetId, geoTags);
    }

    private void start0() {
        this.bm.start();
        this.asm.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        this.asm.stop();
        this.bm.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }
}

