/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.blobstore;

import com.ibm.uclab.csrepl.blobstore.BlobReplicatorImpl;
import com.ibm.uclab.csrepl.moveable.MoveableFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class BlobReplicatorStream
extends InputStream {
    private final BlobReplicatorImpl saver;
    private final MoveableFileInputStream in;
    private byte[] one;
    private final Object updateLock;
    private long writeCount;
    private long readCount;
    private boolean eof;
    private IOException error;

    BlobReplicatorStream(BlobReplicatorImpl saver, MoveableFileInputStream in) {
        this.saver = saver;
        this.updateLock = new Object();
        this.in = in;
    }

    @Override
    public synchronized int read() throws IOException {
        int n;
        if (this.one == null) {
            this.one = new byte[1];
        }
        if ((n = this.read(this.one, 0, this.one.length)) == -1) {
            return n;
        }
        return this.one[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n = 0;
        while (n == 0 && len != 0) {
            boolean eof;
            long writeCount;
            Object object = this.updateLock;
            synchronized (object) {
                while (true) {
                    if (this.error != null) {
                        throw this.error;
                    }
                    writeCount = this.writeCount;
                    eof = this.eof;
                    if (this.readCount < writeCount || eof) break;
                    try {
                        this.updateLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                if (writeCount < this.readCount) {
                    throw new AssertionError((Object)String.format("writeCount went backwards: wc=%d, readCount=%d", writeCount, this.readCount));
                }
            }
            if (this.readCount < writeCount) {
                int cnt = (int)Math.min((long)len, writeCount - this.readCount);
                n = this.in.read(b, off, cnt);
                if (n < 0) {
                    n = 0;
                }
                this.readCount += (long)n;
                continue;
            }
            if (!eof) continue;
            n = -1;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.saver != null) {
            this.saver.unregisterStream(this);
        }
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(long total) {
        Object object = this.updateLock;
        synchronized (object) {
            if (total < this.writeCount) {
                throw new AssertionError((Object)String.format("update total went backwards: total=%d, writeCount=%d", total, this.writeCount));
            }
            this.writeCount = total;
            this.updateLock.notifyAll();
        }
    }

    void preMove() throws IOException {
        this.in.preMove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postMove(long total, File newFile) {
        this.in.postMove(newFile);
        Object object = this.updateLock;
        synchronized (object) {
            this.eof = true;
            this.update(total);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fail(IOException error) {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.error == null) {
                this.error = error;
            }
            this.updateLock.notifyAll();
        }
    }
}

