/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client.ops;

import com.ibm.uclab.csrepl.client.ops.DownloadBase;
import com.ibm.uclab.csrepl.codestation.ArtifactSetReader;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.unix.ModeBits;
import com.urbancode.commons.util.unix.Unix;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

class ArtifactSetWriter {
    private static final Logger log = Logger.getLogger(ArtifactSetWriter.class);
    private Unix unix = new Unix();
    private File destination;
    private ArtifactSetReader reader;
    private Charset outputCharset;
    private String strippedPrefix;
    private boolean setExecuteBits;
    private boolean verifyFiles;
    private Map<File, FileMetadata> savedDirMeta;
    private MessageDigest dig;
    private boolean warnedSymlinks;

    ArtifactSetWriter(File destination, ArtifactSetReader reader) {
        this.destination = destination.getAbsoluteFile();
        this.reader = reader;
        this.savedDirMeta = new HashMap<File, FileMetadata>();
    }

    void setOutputCharset(Charset outputCharset) {
        this.outputCharset = outputCharset;
    }

    void setSetExecuteBits(boolean setExecuteBits) {
        this.setExecuteBits = setExecuteBits;
    }

    void setVerifyFiles(boolean verifyFiles) {
        this.verifyFiles = verifyFiles;
    }

    void setStrippedPrefix(String strippedPrefix) {
        if (strippedPrefix == null) {
            this.strippedPrefix = null;
            return;
        }
        this.strippedPrefix = strippedPrefix = FileMetadata.sanitizePath(strippedPrefix) + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void run() throws IOException {
        ArtifactSetWriter.log.info((Object)("Downloading files to " + this.destination.getAbsolutePath() + "."));
lbl2:
        // 6 sources

        block8: while ((in = this.reader.read()) != null) {
            try {
                meta = in.getMeta();
                dest = this.toFile(meta);
                dest.delete();
                this.createParentDirectory(dest);
                ArtifactSetWriter.log.info((Object)("Downloading: " + meta.getPath()));
                switch (1.$SwitchMap$com$ibm$uclab$csrepl$codestation$FileMetadata$Type[meta.getType().ordinal()]) {
                    case 1: {
                        this.createFile(in, dest, meta);
                        ** break;
                    }
                    case 2: {
                        this.createDirectory(in, dest, meta);
                        ** break;
                    }
                    case 3: {
                        this.createSymlink(in, dest, meta);
                        ** break;
                    }
                    default: {
                        ArtifactSetWriter.log.warn((Object)("Unsupported file type " + (Object)meta.getType() + ": " + meta.getPath()));
                        continue block8;
                    }
                }
            }
            finally {
                in.close();
            }
        }
        for (Map.Entry<File, FileMetadata> e : this.savedDirMeta.entrySet()) {
            this.setMeta(e.getKey(), e.getValue());
        }
        ArtifactSetWriter.log.info((Object)"Download complete.");
    }

    private File toFile(FileMetadata m) {
        String path = m.getPath();
        path = DownloadBase.stripPathPrefix(path, this.strippedPrefix);
        return new File(this.destination, path);
    }

    private void createParentDirectory(File f) throws IOException {
        File parent = f.getParentFile();
        if (parent != null) {
            this.mkdirs(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(InputStream in, File dest, FileMetadata meta) throws IOException {
        byte[] actual;
        byte[] expected;
        OutputStream out;
        String hash = meta.getHash();
        if (this.verifyFiles && hash != null) {
            if (this.dig == null) {
                this.dig = IO.sha256Digester();
            }
            this.dig.reset();
            in = new DigestInputStream(in, this.dig);
        }
        try {
            out = new FileOutputStream(dest);
        }
        catch (FileNotFoundException e) {
            if (dest.isDirectory()) {
                throw new IOException(String.format("Cannot create file '%s': path is a directory", dest.getAbsolutePath()), e);
            }
            throw new IOException("Cannot create file " + dest.getAbsolutePath(), e);
        }
        try {
            if (this.outputCharset != null && meta.getCharset() != null) {
                CharsetDecoder dec = Charset.forName(meta.getCharset()).newDecoder();
                CharsetEncoder enc = this.outputCharset.newEncoder();
                out = IO.transcode((CharsetDecoder)dec, (CharsetEncoder)enc, (OutputStream)out);
            }
            IO.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
        }
        this.setMeta(dest, meta);
        if (this.verifyFiles && hash != null && !Arrays.equals(expected = this.toHashBytes(hash), actual = this.dig.digest())) {
            throw new IOException(String.format("File failed hash check: expected=%s, actual=%s, path=%s", hash, this.toHashString(actual), dest.getAbsolutePath()));
        }
    }

    private void createDirectory(InputStream in, File dest, FileMetadata meta) throws IOException {
        this.mkdirs(dest);
        this.savedDirMeta.put(dest, meta);
    }

    private void createSymlink(InputStream in, File dest, FileMetadata meta) throws IOException {
        if (!this.unix.isUnix()) {
            if (!this.warnedSymlinks) {
                this.warnedSymlinks = true;
                log.warn((Object)"Creating symlinks not supported on this platform");
            }
            log.warn((Object)("Skipping symlink: " + dest.getAbsolutePath()));
            return;
        }
        String target = IO.readText((InputStream)in, (Charset)IO.utf8());
        this.unix.ln(Unix.LinkType.SYMBOLIC, target, dest.getAbsolutePath());
    }

    private void setMeta(File f, FileMetadata m) {
        long lm;
        Integer mo;
        if (f == null || m == null) {
            return;
        }
        if (this.setExecuteBits && m.getType() == FileMetadata.Type.FILE && (mo = m.getUnixMode()) != null) {
            this.setExecuteBits(f, mo);
        }
        if ((lm = m.getLastModified()) != 0L) {
            f.setLastModified(lm);
        }
    }

    private void setExecuteBits(File f, int bits) {
        if (ModeBits.isUserExecutable((int)bits)) {
            boolean ownerOnly = !ModeBits.isGroupExecutable((int)bits) && !ModeBits.isOtherExecutable((int)bits);
            f.setExecutable(true, ownerOnly);
        }
    }

    private byte[] toHashBytes(String h) {
        if (h.length() != 64) {
            throw new RuntimeException("Invalid SHA-256 hash: " + h);
        }
        try {
            return Hex.decodeHex((char[])h.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException("Invalid SHA-256 hash: " + h, e);
        }
    }

    private String toHashString(byte[] h) {
        return Hex.encodeHexString((byte[])h);
    }

    private void mkdirs(File dir) throws IOException {
        dir.mkdirs();
        if (!dir.isDirectory()) {
            if (dir.isFile()) {
                throw new IOException(String.format("Cannot create directory '%s': path is a file", dir.getAbsolutePath()));
            }
            for (File p = dir.getParentFile(); p != null; p = p.getAbsoluteFile()) {
                if (!p.isFile()) continue;
                throw new IOException(String.format("Cannot create directory '%s': parent component is a file: %s", dir.getAbsolutePath(), p.getAbsolutePath()));
            }
            throw new IOException("Cannot create directory: " + dir.getAbsolutePath());
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$ibm$uclab$csrepl$codestation$FileMetadata$Type;

        static {
            $SwitchMap$com$ibm$uclab$csrepl$codestation$FileMetadata$Type = new int[FileMetadata.Type.values().length];
            try {
                1.$SwitchMap$com$ibm$uclab$csrepl$codestation$FileMetadata$Type[FileMetadata.Type.FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$ibm$uclab$csrepl$codestation$FileMetadata$Type[FileMetadata.Type.DIRECTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$ibm$uclab$csrepl$codestation$FileMetadata$Type[FileMetadata.Type.SYMLINK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

