/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.AggregateItemMeta;
import com.urbancode.codestation2.common.aggregate.ItemTable;
import com.urbancode.codestation2.common.aggregate.ItemTableRO;
import com.urbancode.codestation2.common.aggregate.ItemTableRW;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateWriter
implements Closeable {
    private Aggregate aggr;
    private File permDir;
    private File tempDir;
    private File tableFile;
    private ItemTableRW table;
    private ItemTableRO readOnlyTable;
    private boolean aborted;
    private File permDataFile;
    private File tempDataFile;
    private OutputStream out;
    private long pos;
    private boolean tableModified;
    private byte[] buffer;

    AggregateWriter(Aggregate aggr, ItemTableRW table, File permDir, File tempDir, File tableFile) {
        this.aggr = aggr;
        this.table = table;
        this.permDir = permDir;
        this.tempDir = tempDir;
        this.tableFile = tableFile;
    }

    public ItemTable getTable() {
        if (!this.isOpen()) {
            throw new IllegalStateException("writer closed");
        }
        if (this.readOnlyTable == null) {
            this.readOnlyTable = new ItemTableRO(this.table);
        }
        return this.readOnlyTable;
    }

    public boolean isMetaOnly() {
        if (!this.isOpen()) {
            throw new IllegalStateException("writer closed");
        }
        return this.table.isMetaOnly();
    }

    public void setMetaOnly(boolean metaOnly) {
        if (!this.isOpen()) {
            throw new IllegalStateException("writer closed");
        }
        boolean old = this.table.isMetaOnly();
        this.table.setMetaOnly(metaOnly);
        if (old != metaOnly) {
            this.tableModified = true;
        }
    }

    public AggregateItem write(int typeWithFlags, String path, InputStream in, MessageDigest dig) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("writer closed");
        }
        boolean metaOnly = (typeWithFlags & Integer.MIN_VALUE) != 0;
        boolean writeData = !metaOnly && in != null;
        if (!Aggregate.isPathValid(path = Aggregate.sanitizePath(path))) {
            throw new IOException("invalid path: " + path);
        }
        if (dig != null) {
            dig.reset();
        }
        if (writeData) {
            this.openDataFile();
        }
        long offset = this.pos;
        if (!writeData) {
            offset = 0L;
        }
        long length = 0L;
        if (in != null) {
            int read;
            this.initBuffer();
            while ((read = in.read(this.buffer)) != -1) {
                if (dig != null) {
                    dig.update(this.buffer, 0, read);
                }
                if (writeData) {
                    this.out.write(this.buffer, 0, read);
                }
                length += (long)read;
            }
        }
        if (writeData) {
            this.pos += length;
        }
        String hash = this.createHash(dig);
        String fileName = ".urbancode-zero";
        if (writeData) {
            fileName = this.tempDataFile.getName();
        }
        AggregateItem item = new AggregateItem(typeWithFlags, path, fileName, offset, length);
        item.setHash(hash);
        this.table.add(item);
        this.tableModified = true;
        return item;
    }

    public AggregateItem write(AggregateItemMeta meta, InputStream in, MessageDigest dig) throws IOException {
        AggregateItem item = this.write(meta.getTypeWithFlags(), meta.getPath(), in, dig);
        String hash = item.getHash();
        item.updateFromMeta(meta);
        if (dig != null) {
            item.setHash(hash);
        }
        return item;
    }

    public AggregateItem writeZero(int typeWithFlags, String path, long length, MessageDigest dig) {
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        int offset = 0;
        AggregateItem item = new AggregateItem(typeWithFlags, path, ".urbancode-zero", offset, length);
        if (dig != null) {
            int n;
            this.initBuffer();
            Arrays.fill(this.buffer, (byte)0);
            for (long len = length; len > 0L; len -= (long)n) {
                n = (int)Math.min(len, (long)this.buffer.length);
                dig.update(this.buffer, 0, n);
            }
            String hash = this.createHash(dig);
            item.setHash(hash);
        }
        this.table.add(item);
        this.tableModified = true;
        return item;
    }

    public AggregateItem writeZero(AggregateItemMeta meta, long length, MessageDigest dig) {
        AggregateItem item = this.writeZero(meta.getTypeWithFlags(), meta.getPath(), length, dig);
        String hash = item.getHash();
        item.updateFromMeta(meta);
        if (dig != null) {
            item.setHash(hash);
        }
        return item;
    }

    public AggregateItem delete(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("writer closed");
        }
        if (!Aggregate.isPathValid(path = Aggregate.sanitizePath(path))) {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        AggregateItem item = this.table.remove(path);
        if (item != null) {
            this.tableModified = true;
        }
        return item;
    }

    public void abort() throws IOException {
        if (this.isOpen()) {
            this.aborted = true;
            OutputStream o = this.out;
            File f = this.tempDataFile;
            this.out = null;
            this.tempDataFile = null;
            this.table = null;
            this.readOnlyTable = null;
            this.tableModified = false;
            if (o != null) {
                o.close();
            }
            if (f != null) {
                f.delete();
            }
            if (this.aggr != null) {
                this.aggr.writerClosed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            OutputStream o = this.out;
            File f = this.tempDataFile;
            ItemTableRW t = this.table;
            this.out = null;
            this.tempDataFile = null;
            this.table = null;
            this.readOnlyTable = null;
            this.buffer = null;
            boolean ok = false;
            try {
                if (o != null) {
                    o.close();
                }
                if (f != null) {
                    this.permDataFile = new File(this.permDir, f.getName());
                    if (!this.rename(f, this.permDataFile)) {
                        try {
                            this.copy(f, this.permDataFile);
                        }
                        catch (IOException e) {
                            throw (IOException)new IOException("could not commit data file").initCause(e);
                        }
                    }
                }
                if (this.tableModified || t.isNewTable()) {
                    this.commitFileTable(t);
                    this.tableModified = true;
                }
                ok = true;
            }
            finally {
                if (!ok) {
                    this.aborted = true;
                    if (this.permDataFile != null) {
                        this.permDataFile.delete();
                        this.permDataFile = null;
                    }
                }
                if (f != null) {
                    f.delete();
                }
                if (this.aggr != null) {
                    this.aggr.writerClosed();
                }
            }
        }
    }

    public File getDataFile() {
        if (this.isOpen()) {
            throw new IllegalStateException("writer open");
        }
        if (this.aborted) {
            throw new IllegalStateException("writer aborted");
        }
        return this.permDataFile;
    }

    public boolean isAggregateModified() {
        if (this.isOpen()) {
            throw new IllegalStateException("writer open");
        }
        return this.tableModified;
    }

    public boolean isOpen() {
        return this.table != null;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    void renameDataFiles(Map<String, String> renaming) throws IOException {
        if (new HashSet<String>((renaming = new HashMap<String, String>(renaming)).values()).size() != renaming.size()) {
            throw new IllegalArgumentException("renaming is not one-to-one");
        }
        HashSet<String> renamed = new HashSet<String>();
        for (AggregateItem item : this.table) {
            String oldName = item.getDataFileName();
            String newName = renaming.get(oldName);
            if (newName == null) continue;
            item.setDataFileName(newName);
            this.tableModified = true;
            if (renamed.contains(oldName)) continue;
            File oldFile = new File(this.permDir, oldName);
            File newFile = new File(this.permDir, newName);
            oldFile.renameTo(newFile);
            renamed.add(oldName);
        }
    }

    private void openDataFile() throws IOException {
        if (this.out == null) {
            this.tempDataFile = this.getTempFile();
            this.makeParentDir(this.tempDataFile);
            this.out = new FileOutputStream(this.tempDataFile);
            this.pos = 0L;
        }
    }

    private void commitFileTable(ItemTableRW table) throws IOException {
        File temp = this.getTempFile();
        try {
            table.write(temp);
            if (this.commitFileTableOnSameVolume(temp)) {
                return;
            }
            if (this.commitFileTableOnDifferentVolume(temp)) {
                return;
            }
            if (Aggregate.isWindows() && this.commitFileTableOnWindows(temp)) {
                return;
            }
            throw new IOException("could not commit table file");
        }
        finally {
            temp.delete();
        }
    }

    private boolean commitFileTableOnSameVolume(File newTable) throws IOException {
        return this.rename(newTable, this.tableFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitFileTableOnDifferentVolume(File newTable) throws IOException {
        File parent = this.tableFile.getParentFile();
        File temp = new File(parent, this.getTempName());
        try {
            this.copy(newTable, temp);
            boolean bl = this.rename(temp, this.tableFile);
            return bl;
        }
        finally {
            temp.delete();
        }
    }

    private boolean commitFileTableOnWindows(File newTable) throws IOException {
        File backup = this.getBackupTableFile();
        int tries = 0;
        int timeout = 25;
        while (true) {
            ++tries;
            this.rename(this.tableFile, backup);
            if (this.commitFileTableOnSameVolume(newTable)) {
                backup.delete();
                return true;
            }
            if (this.commitFileTableOnDifferentVolume(newTable)) {
                backup.delete();
                return true;
            }
            if (tries >= 8) {
                if (!this.rename(backup, this.tableFile) && !this.tableFile.isFile()) {
                    throw new IOException("could not commit table file or restore backup");
                }
                return false;
            }
            Aggregate.sleep(timeout);
            timeout *= 2;
        }
    }

    private File getTempFile() {
        String name = this.getTempName();
        return new File(this.tempDir, name);
    }

    private File getBackupTableFile() {
        File parent = this.tableFile.getParentFile();
        return new File(parent, this.tableFile.getName() + ".bak-" + this.getTempName());
    }

    private String getTempName() {
        return UUID.randomUUID().toString().toLowerCase(Locale.US);
    }

    private void makeParentDir(File f) throws IOException {
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                throw new IOException("Can't create directory " + parent.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File src, File dst) throws IOException {
        byte[] buffer = new byte[8192];
        FileInputStream in = new FileInputStream(src);
        try {
            this.makeParentDir(dst);
            FileOutputStream out = new FileOutputStream(dst);
            try {
                int c;
                while ((c = in.read(buffer)) != -1) {
                    out.write(buffer, 0, c);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    private boolean rename(File src, File dst) {
        File parent = dst.getParentFile();
        if (parent != null) {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                return false;
            }
        }
        return src.renameTo(dst);
    }

    private String createHash(MessageDigest dig) {
        String hash = null;
        if (dig != null) {
            String alg = dig.getAlgorithm();
            byte[] digest = dig.digest();
            StringBuilder sb = new StringBuilder();
            sb.append(alg);
            sb.append('{');
            sb.append(Hex.encodeHex((byte[])digest, (boolean)false));
            sb.append('}');
            hash = sb.toString();
        }
        return hash;
    }

    private void initBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[65536];
        }
    }
}

