/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.ItemTable;
import com.urbancode.codestation2.common.aggregate.PathFilter;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemTableFiltered
implements ItemTable {
    private static final Object NONE = new Object();
    private static final Object END = new Object();
    private ItemTable delegate;
    private PathFilter filter;
    private int size;

    public ItemTableFiltered(ItemTable delegate, PathFilter filter) {
        if (filter != null && filter.isAcceptAll()) {
            filter = null;
        }
        this.delegate = delegate;
        this.filter = filter;
        this.size = -1;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.setSize();
        }
        return this.size;
    }

    @Override
    public AggregateItem get(String path) {
        if (!Aggregate.isPathValid(path = Aggregate.sanitizePath(path))) {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        if (this.accept(path)) {
            return this.delegate.get(path);
        }
        return null;
    }

    @Override
    public boolean isMetaOnly() {
        return this.delegate.isMetaOnly();
    }

    @Override
    public Iterator<AggregateItem> iterator() {
        return new Itr();
    }

    void setSize() {
        int count = 0;
        for (AggregateItem i : this.delegate) {
            assert (Aggregate.isPathValid(i.getPath()));
            if (!this.accept(i.getPath())) continue;
            ++count;
        }
        this.size = count;
    }

    boolean accept(String path) {
        assert (Aggregate.isPathValid(path));
        if (this.filter == null) {
            return true;
        }
        return this.filter.accept(path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Itr
    implements Iterator<AggregateItem> {
        Iterator<AggregateItem> itr;
        Object next;

        Itr() {
            this.itr = ItemTableFiltered.this.delegate.iterator();
            this.next = NONE;
        }

        @Override
        public boolean hasNext() {
            AggregateItem item;
            if (this.next == END) {
                return false;
            }
            do {
                if (!this.itr.hasNext()) {
                    this.next = END;
                    return false;
                }
                item = this.itr.next();
                assert (Aggregate.isPathValid(item.getPath()));
            } while (!ItemTableFiltered.this.accept(item.getPath()));
            this.next = item;
            return true;
        }

        @Override
        public AggregateItem next() {
            if (this.next == END) {
                throw new NoSuchElementException();
            }
            if (this.next == NONE && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            AggregateItem item = (AggregateItem)this.next;
            this.next = NONE;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

