/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate.streams;

import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import java.io.IOException;
import java.io.InputStream;

final class SeekableInputStreamIS
extends SeekableInputStream {
    private final InputStream in;
    private long pos;

    SeekableInputStreamIS(InputStream in) {
        this.in = in;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void seek(long position) throws IOException {
        if (position < this.pos) {
            throw new IOException("Reverse seek not supported");
        }
        if (position > this.pos) {
            long len;
            long n;
            long prevN = -1L;
            for (len = position - this.pos; len > 0L; len -= n) {
                n = this.in.skip(len);
                this.pos += n;
                if (n == 0L && prevN == 0L) break;
                prevN = n;
            }
            if (len > 0L) {
                throw new IOException("Cannot reposition to " + position);
            }
        }
    }

    public synchronized int read() throws IOException {
        int n = this.in.read();
        if (n > 0) {
            ++this.pos;
        }
        return n;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (n > 0) {
            this.pos += (long)n;
        }
        return n;
    }
}

