/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.AggregateInputStream;
import com.urbancode.codestation2.common.aggregate.AggregateInputStreamSec;
import com.urbancode.codestation2.common.aggregate.AggregateItem;
import com.urbancode.codestation2.common.aggregate.AggregateItemMeta;
import com.urbancode.codestation2.common.aggregate.PathFilter;
import com.urbancode.codestation2.common.aggregate.SectionInputStream;
import com.urbancode.commons.util.IO;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Formatter;

public class AggregateStreamReader
implements Closeable {
    private String hashAlg;
    private DataInputStream dataIn;
    private DigestInputStream digIn;
    private boolean atBeginning;
    private boolean atEnd;
    private byte[] expectedHash;
    private SectionInputStream previous;
    private PathFilter filter;

    public AggregateStreamReader(InputStream in, PathFilter filter) throws IOException {
        if (filter != null && filter.isAcceptAll()) {
            filter = null;
        }
        this.filter = filter;
        this.digIn = new DigestInputStream(in, null);
        this.digIn.on(false);
        this.dataIn = new DataInputStream(this.digIn);
        this.hashAlg = this.dataIn.readUTF();
        if (this.hashAlg.length() > 0) {
            MessageDigest dig;
            try {
                dig = MessageDigest.getInstance(this.hashAlg);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("unknown hash algorithm: " + this.hashAlg);
            }
            this.digIn.setMessageDigest(dig);
            this.digIn.on(true);
        }
        this.atBeginning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStreamTo(File file) throws IOException {
        if (this.dataIn == null) {
            throw new IOException("reader closed");
        }
        if (!this.atBeginning) {
            throw new IOException("not at beginning of stream");
        }
        this.atBeginning = false;
        File parent = file.getParentFile();
        if (parent != null) {
            IO.mkdirs((File)parent);
        }
        DataOutputStream dataOut = IO.data((OutputStream)IO.openOutput((File)file));
        try {
            dataOut.writeUTF(this.hashAlg);
            int type = 0;
            while (type != 1) {
                type = this.readType();
                long length = this.readLength();
                if (type == 1 && length != 0L) {
                    throw new IOException("corrupt stream: end marker len != 0");
                }
                dataOut.writeInt(type);
                dataOut.writeLong(length);
                if (IO.copy((InputStream)this.dataIn, (OutputStream)dataOut, (long)length) == 0L) continue;
                throw new IOException("incomplete write");
            }
            this.endStream();
            if (this.expectedHash != null) {
                dataOut.writeShort(this.expectedHash.length);
                dataOut.write(this.expectedHash);
            }
        }
        finally {
            dataOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregateInputStream read() throws IOException {
        SectionInputStream metaSection;
        AggregateInputStreamSec stream = null;
        while (stream == null && (metaSection = this.readSection()) != null) {
            AggregateItemMeta meta;
            try {
                if (metaSection.getType() != 2) {
                    throw new IOException("stream corrupt: expected meta section");
                }
                meta = this.readMeta(metaSection);
            }
            finally {
                metaSection.close();
            }
            SectionInputStream dataSection = this.readSection();
            if (dataSection == null) {
                throw new IOException("stream corrupt: expected data section");
            }
            try {
                String path;
                AggregateItem item = new AggregateItem(meta, null, 0L, dataSection.getLength());
                stream = new AggregateInputStreamSec(item, dataSection);
                if (dataSection.getType() != 3) {
                    throw new IOException("stream corrupt: expected data section");
                }
                if (this.filter == null || this.filter.accept(path = stream.getItem().getPath())) continue;
                stream.close();
                stream = null;
            }
            finally {
                if (stream != null) continue;
                dataSection.close();
            }
        }
        return stream;
    }

    public void verify() throws IOException {
        byte[] actualHash;
        if (this.dataIn == null) {
            throw new IOException("reader closed");
        }
        if (!this.atEnd) {
            throw new IllegalStateException("not at end of stream");
        }
        MessageDigest dig = this.digIn.getMessageDigest();
        if (dig != null && !Arrays.equals(this.expectedHash, actualHash = dig.digest())) {
            Formatter fmt = new Formatter();
            fmt.format("corrupt stream: failed hash verification: alg=%s", dig.getAlgorithm());
            fmt.format(" expected=", new Object[0]);
            for (byte b : this.expectedHash) {
                fmt.format("%02x", b);
            }
            fmt.format(", actual=", new Object[0]);
            for (byte b : actualHash) {
                fmt.format("%02x", b);
            }
            String msg = fmt.toString();
            fmt.close();
            throw new IOException(msg);
        }
    }

    @Override
    public void close() throws IOException {
        DataInputStream i = this.dataIn;
        this.dataIn = null;
        this.digIn = null;
        this.expectedHash = null;
        this.previous = null;
        if (i != null) {
            ((InputStream)i).close();
        }
    }

    SectionInputStream readSection() throws IOException {
        if (this.dataIn == null) {
            throw new IOException("reader closed");
        }
        if (this.atEnd) {
            return null;
        }
        if (this.previous != null && this.previous.isOpen()) {
            throw new IllegalStateException("previous stream is open");
        }
        this.atBeginning = false;
        int type = this.readType();
        long length = this.readLength();
        if (type == 1) {
            if (length != 0L) {
                throw new IOException("corrupt stream: end marker len != 0");
            }
            this.endStream();
            return null;
        }
        this.previous = new SectionInputStream(type, this.dataIn, length);
        return this.previous;
    }

    private int readType() throws IOException {
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException e) {
            throw (IOException)new IOException("corrupt stream: section type truncated").initCause(e);
        }
    }

    private long readLength() throws IOException {
        try {
            long len = this.dataIn.readLong();
            if (len < 0L) {
                throw new IOException("corrupt stream: invalid section length");
            }
            return len;
        }
        catch (EOFException e) {
            throw (IOException)new IOException("corrupt stream: section length truncated").initCause(e);
        }
    }

    private void endStream() throws IOException {
        this.atEnd = true;
        this.digIn.on(false);
        MessageDigest dig = this.digIn.getMessageDigest();
        if (dig != null) {
            try {
                int len = this.dataIn.readUnsignedShort();
                byte[] expected = new byte[len];
                this.dataIn.readFully(expected);
                this.expectedHash = expected;
            }
            catch (EOFException e) {
                throw (IOException)new IOException("corrupt stream: hash truncated").initCause(e);
            }
        }
        if (this.dataIn.read() != -1) {
            throw new IOException("corrupt stream: data after stream end");
        }
    }

    private AggregateItemMeta readMeta(InputStream in) throws IOException {
        try {
            ObjectInputStream oin = new ObjectInputStream(in);
            return (AggregateItemMeta)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("invalid meta class").initCause(e);
        }
    }
}

