/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import java.io.IOException;
import java.io.InputStream;

class SectionInputStream
extends InputStream {
    private final int type;
    private InputStream in;
    private long length;
    private long remaining;

    SectionInputStream(int type, InputStream in, long length) {
        this.type = type;
        this.in = in;
        this.length = length;
        this.remaining = length;
    }

    public int getType() {
        return this.type;
    }

    public synchronized long getLength() {
        return this.length;
    }

    public synchronized long getRemaining() {
        return this.remaining;
    }

    public synchronized boolean isOpen() {
        return this.in != null;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.in == null) {
            throw new IOException("stream closed");
        }
        if (this.remaining <= 0L) {
            return -1;
        }
        int b = this.in.read();
        if (b != -1) {
            --this.remaining;
        }
        if (b == -1 && this.remaining > 0L) {
            throw new IOException("stream truncated");
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            throw new IOException("stream closed");
        }
        if (this.remaining <= 0L) {
            return -1;
        }
        int n = this.in.read(b, off, len = (int)Math.min(this.remaining, (long)len));
        if (n != -1) {
            this.remaining -= (long)n;
        }
        if (n == -1 && this.remaining > 0L) {
            throw new IOException("stream truncated");
        }
        return n;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.in != null) {
            byte[] buf = new byte[4096];
            while (this.read(buf) != -1) {
            }
            this.in = null;
            this.remaining = 0L;
        }
    }
}

