/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.client;

import com.ibm.uclab.csrepl.client.CallResult;
import com.ibm.uclab.csrepl.client.CodestationClient;
import com.ibm.uclab.csrepl.codestation.ArtifactSetBuilder;
import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.streams.HashInjectingInputStream;
import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.unix.UnixPermissions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;

class ArtifactSetBuilderClientMeta
implements ArtifactSetBuilder {
    private static final Logger log = Logger.getLogger(ArtifactSetBuilderClientMeta.class);
    private final UUID artifactSetId;
    private final HttpClient client;
    private final String serviceUrl;
    private MessageDigest dig;
    private byte[] buf;
    private List<FileMetadata> metas;
    private boolean aborted;
    private boolean committed;

    ArtifactSetBuilderClientMeta(UUID artifactSetId, HttpClient client, String serviceUrl) {
        this.artifactSetId = artifactSetId;
        this.client = client;
        this.serviceUrl = serviceUrl;
        this.metas = new ArrayList<FileMetadata>();
    }

    @Override
    public void addFromLister(FileLister lister) throws IOException {
        if (this.committed || this.aborted) {
            throw new IOException("Closed");
        }
        for (TypedFile f : lister.list()) {
            File file = f.translate(lister.base());
            try {
                HashResult hr;
                FileMetadata.Type type;
                switch (f.type()) {
                    case DIRECTORY: {
                        type = FileMetadata.Type.DIRECTORY;
                        hr = this.getHash(null, true);
                        break;
                    }
                    case REGULAR: {
                        type = FileMetadata.Type.FILE;
                        hr = this.getHash(new FileInputStream(file), true);
                        break;
                    }
                    case SYMLINK: {
                        type = FileMetadata.Type.SYMLINK;
                        hr = this.getHash(new ByteArrayInputStream(f.linkPath().getBytes(IO.utf8())), true);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Missing case: " + f.type());
                    }
                }
                FileMetadata m = new FileMetadata(type, f.path(), hr.length);
                m.setHash(hr.hash);
                m.setLastModified(file.lastModified());
                this.setPerms(m, (UnixPermissions)f.permissionView(UnixPermissions.class));
                this.metas.add(m);
            }
            catch (FileNotFoundException swallow) {}
        }
    }

    @Override
    public void addItem(FileMetadata meta, InputStream content) throws IOException {
        if (this.committed || this.aborted) {
            throw new IOException("Closed");
        }
        if (meta.getType() == FileMetadata.Type.DIRECTORY && content != null) {
            throw new IllegalArgumentException("Directory type cannot accept content");
        }
        if (meta.getType() == FileMetadata.Type.SYMLINK && content == null) {
            throw new NullPointerException("Symlink type must have link target as content");
        }
        if (content == null) {
            meta = meta.copy();
        } else {
            HashResult hr = this.getHash(content, false);
            meta = meta.withLength(hr.length);
            meta.setHash(hr.hash);
        }
        this.metas.add(meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit() throws IOException {
        if (this.aborted || this.committed) return;
        this.committed = true;
        List<FileMetadata> metas = this.metas;
        this.metas = null;
        String reqUrl = String.format("%s/%s/meta/update", this.serviceUrl, this.artifactSetId);
        HttpPost req = new HttpPost(reqUrl);
        JSONArray jarray = new JSONArray();
        for (FileMetadata m : metas) {
            jarray.put((Object)m.toJSON());
        }
        byte[] content = jarray.toString().getBytes(IO.utf8());
        MessageDigest dig = IO.md5Digester();
        ContentType ct = ContentType.create((String)"application/json", (Charset)IO.utf8());
        HashInjectingInputStream in = new HashInjectingInputStream(new ByteArrayInputStream(content), dig);
        req.setHeader("X-Codestation-Digest-Algorithm", dig.getAlgorithm());
        req.setEntity((HttpEntity)new InputStreamEntity((InputStream)in, -1L, ct));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing: POST " + req.getURI()));
        }
        CallResult result = new CallResult("POST", reqUrl, (HttpRequestBase)req, this.client.execute((HttpUriRequest)req));
        try {
            StatusLine status = result.res.getStatusLine();
            switch (status.getStatusCode()) {
                case 204: {
                    if (!log.isDebugEnabled()) return;
                    log.debug((Object)String.format("Request succeeded: %s: %03d %s", reqUrl, status.getStatusCode(), status.getReasonPhrase()));
                    return;
                }
                case 404: {
                    throw CodestationClient.notFound(this.artifactSetId, result);
                }
                default: {
                    throw CodestationClient.unacceptableResponse(result);
                }
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)result.res.getEntity());
        }
    }

    @Override
    public void abort() throws IOException {
        if (!this.aborted && !this.committed) {
            this.aborted = true;
            this.metas = null;
        }
    }

    @Override
    public boolean isMetadataOnly() {
        return false;
    }

    private void setPerms(FileMetadata meta, UnixPermissions perms) {
        if (perms == null) {
            return;
        }
        String user = perms.getUser();
        String group = perms.getGroup();
        int mode = perms.getMode();
        if (user != null && user.length() == 0) {
            user = null;
        }
        if (group != null && group.length() == 0) {
            group = null;
        }
        meta.setUnixUser(user);
        meta.setUnixGroup(group);
        meta.setUnixMode(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashResult getHash(InputStream in, boolean close) throws IOException {
        if (in == null) {
            return new HashResult(null, 0L);
        }
        try {
            int n;
            if (this.dig == null) {
                this.dig = IO.sha256Digester();
            }
            if (this.buf == null) {
                this.buf = new byte[4096];
            }
            this.dig.reset();
            long len = 0L;
            while ((n = in.read(this.buf)) != -1) {
                this.dig.update(this.buf, 0, n);
                len += (long)n;
            }
            byte[] h = this.dig.digest();
            HashResult hashResult = new HashResult(Hex.encodeHexString((byte[])h), len);
            return hashResult;
        }
        finally {
            if (close) {
                in.close();
            }
        }
    }

    static class HashResult {
        String hash;
        long length;

        HashResult(String hash, long length) {
            this.hash = hash;
            this.length = length;
        }
    }
}

