/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.moveable;

import com.ibm.uclab.csrepl.moveable.MoveableFileInputStream;
import com.ibm.uclab.csrepl.moveable.MoveableFileInputStreamFactory;
import com.ibm.uclab.csrepl.moveable.MoveableFileInputStreamNonPosix;
import com.ibm.uclab.csrepl.moveable.MoveableFileInputStreamPosix;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.UUID;

public class MoveableFileInputStreamFactoryImpl
implements MoveableFileInputStreamFactory {
    private final boolean hasPosixSemantics;

    public MoveableFileInputStreamFactoryImpl(File testDir) {
        this.hasPosixSemantics = this.testSemantics(testDir);
    }

    @Override
    public MoveableFileInputStream open(File file) throws FileNotFoundException {
        if (this.hasPosixSemantics) {
            return new MoveableFileInputStreamPosix(file);
        }
        return new MoveableFileInputStreamNonPosix(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testSemantics(File testDir) {
        testDir = testDir.getAbsoluteFile();
        File src = new File(testDir, UUID.randomUUID().toString());
        File dst = new File(testDir, UUID.randomUUID().toString());
        try {
            boolean bl;
            testDir.mkdirs();
            FileInputStream srcIn = new FileInputStream(src);
            try {
                bl = src.renameTo(dst);
            }
            catch (Throwable throwable) {
                try {
                    srcIn.close();
                    throw throwable;
                }
                catch (Exception e) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            srcIn.close();
            return bl;
        }
        finally {
            src.delete();
            dst.delete();
        }
    }
}

