/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.codestation.FileMetadata;
import com.ibm.uclab.csrepl.rest.Errors;
import com.urbancode.commons.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

class MetaParser {
    private InputStream in;
    private MediaType type;
    private List<FileMetadata> meta;

    MetaParser(InputStream in, MediaType type) {
        this.in = in;
        this.type = type;
    }

    List<FileMetadata> getMeta() throws IOException {
        Charset cs;
        if (this.meta != null) {
            return this.meta;
        }
        if (this.in == null) {
            return null;
        }
        if (this.type == null) {
            this.type = MediaType.APPLICATION_JSON_TYPE;
        }
        if (!this.type.getType().equals(MediaType.APPLICATION_JSON_TYPE.getType())) {
            throw Errors.badRequest("Invalid media type: " + this.type);
        }
        if (!this.type.getSubtype().equals(MediaType.APPLICATION_JSON_TYPE.getSubtype())) {
            throw Errors.badRequest("Invalid media type: " + this.type);
        }
        String charset = (String)this.type.getParameters().get("charset");
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            cs = Charset.forName(charset);
        }
        catch (Exception e) {
            throw Errors.badRequest("Invalid charset: " + charset);
        }
        String json = IO.readText((InputStream)this.in, (Charset)cs);
        try {
            this.meta = this.getMeta(json);
            return this.meta;
        }
        catch (JSONException e) {
            throw Errors.badRequest("Invalid filter JSON: " + e.getMessage(), e);
        }
    }

    private List<FileMetadata> getMeta(String json) throws JSONException {
        JSONArray array = new JSONArray(json);
        ArrayList<FileMetadata> meta = new ArrayList<FileMetadata>();
        for (int i = 0; i < array.length(); ++i) {
            meta.add(FileMetadata.fromJSON(array.getJSONObject(i)));
        }
        return meta;
    }
}

