/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.asm;

import com.ibm.uclab.csrepl.asm.ArtifactSetManagerImpl;
import com.ibm.uclab.csrepl.lifecycle.LifecycleStoppedException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.log4j.Logger;

class BackgroundSynchronizer
implements Runnable {
    private static final Logger log = Logger.getLogger(BackgroundSynchronizer.class);
    private final ArtifactSetManagerImpl asm;
    private final long interval;

    BackgroundSynchronizer(ArtifactSetManagerImpl asm, long interval) {
        this.asm = asm;
        this.interval = interval;
    }

    @Override
    public void run() {
        Thread t = Thread.currentThread();
        t.setName(t.getName() + ": synchronizer");
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.interval);
                    this.asm.synchronizeWithRemote();
                }
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Terminated by interrupt", (Throwable)e);
            }
            catch (HttpHostConnectException e) {
                log.warn((Object)"Remote ASM server refused connection; skipping synchronization cycle.");
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"STACKTRACE", (Throwable)e);
                continue;
            }
            catch (LifecycleStoppedException e) {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Stopped", (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)"Error while synchronizing", e);
                continue;
            }
            break;
        }
    }
}

