/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.rest.Errors;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestParam {
    private final String text;

    static MessageDigest toDigest(DigestParam param) {
        if (param == null) {
            return null;
        }
        return param.getDigest();
    }

    public DigestParam(String text) {
        this.text = text;
    }

    public String toString() {
        return this.getText();
    }

    public String getText() {
        return this.text;
    }

    public MessageDigest getDigest() {
        if (this.text == null) {
            return null;
        }
        String text = this.text.trim();
        if (text.length() == 0) {
            return null;
        }
        try {
            return MessageDigest.getInstance(text);
        }
        catch (NoSuchAlgorithmException e) {
            throw Errors.badRequest("Unsupported digest algorithm: " + text, e);
        }
    }
}

