/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate.streams;

import com.urbancode.codestation2.common.aggregate.streams.SeekableInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

final class SeekableInputStreamRAF
extends SeekableInputStream {
    private final RandomAccessFile file;

    SeekableInputStreamRAF(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public synchronized void seek(long position) throws IOException {
        this.file.seek(position);
    }

    @Override
    public synchronized int read() throws IOException {
        return this.file.read();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        return this.file.read(b, off, len);
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long total = 0L;
        int skipped = -1;
        while (n > 0L && skipped != 0) {
            int m = (int)Math.min(Integer.MAX_VALUE, n);
            skipped = this.file.skipBytes(m);
            n -= (long)skipped;
            total += (long)skipped;
        }
        return total;
    }
}

