/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

final class Errors {
    private static final Logger log = Logger.getLogger(Errors.class);

    static WebApplicationException notFound(String message) {
        return Errors.notFound(message, null);
    }

    static WebApplicationException notFound(String message, Throwable cause) {
        return Errors.createException(Response.Status.NOT_FOUND, message, cause);
    }

    static WebApplicationException badRequest(String message) {
        return Errors.badRequest(message, null);
    }

    static WebApplicationException badRequest(String message, Throwable cause) {
        return Errors.createException(Response.Status.BAD_REQUEST, message, cause);
    }

    static WebApplicationException serviceUnavailable(String message) {
        return Errors.serviceUnavailable(message, null);
    }

    static WebApplicationException serviceUnavailable(String message, Throwable cause) {
        return Errors.createException(Response.Status.SERVICE_UNAVAILABLE, message, cause);
    }

    static WebApplicationException unauthorized(String message) {
        return Errors.unauthorized(message, null);
    }

    static WebApplicationException unauthorized(String message, Throwable cause) {
        return Errors.createException(Response.Status.UNAUTHORIZED, message, cause);
    }

    static WebApplicationException forbidden(String message) {
        return Errors.forbidden(message, null);
    }

    static WebApplicationException forbidden(String message, Throwable cause) {
        return Errors.createException(Response.Status.FORBIDDEN, message, cause);
    }

    private static WebApplicationException createException(Response.Status status, String message, Throwable cause) {
        if (message != null) {
            message = message.trim() + "\r\n";
        }
        Response r = Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build();
        WebApplicationException e = new WebApplicationException(cause, r);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Created WebApplicationException", (Throwable)e);
        }
        return e;
    }

    private Errors() {
        throw new UnsupportedOperationException();
    }
}

