/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils;

import com.urbancode.commons.fileutils.DirectoryFileFilter;
import com.urbancode.commons.fileutils.DirectoryOnlyFilenameFilter;
import com.urbancode.commons.fileutils.FileDeletionResults;
import com.urbancode.commons.util.Paths;
import com.urbancode.commons.util.UnsafePathException;
import com.urbancode.commons.util.logging.LogUtil;
import com.urbancode.commons.util.unix.Unix;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);
    private static final long DELETE_RETRY_PAUSE = Long.getLong("com.urbancode.commons.fileutils.FileUtils.deleteRetryPauseMillis", 1000L);
    private static final int MAX_DELETE_ATTEMPT_COUNT = Integer.getInteger("com.urbancode.commons.fileutils.FileUtils.maxDeleteAttemptCount", 15);
    private static final boolean DISABLE_JAVA_7_FEATURES = Boolean.getBoolean("com.urbancode.commons.fileutils.FileUtils.disableJava7Features");
    private static DirectoryOnlyFilenameFilter subDirectoryFilter = new DirectoryOnlyFilenameFilter();
    public static final double KB = 1024.0;
    public static final double MB = 1048576.0;
    public static final double GB = 1.073741824E9;

    public static File assertDirectory(String directory) {
        File file = new File(directory);
        return FileUtils.assertDirectory(file);
    }

    public static File assertDirectory(File directory) {
        while (directory.getPath().endsWith(File.separator + ".")) {
            directory = directory.getParentFile();
        }
        if (!directory.mkdirs() && !directory.isDirectory()) {
            throw new IllegalStateException("Failed to create directory " + directory);
        }
        return directory;
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File file2 : files = FileUtils.listFiles(file)) {
                FileUtils.deleteFile(file2);
            }
        }
        return file.delete();
    }

    public static boolean deleteFileSafely(File file) throws IOException {
        if (file.isDirectory() && !FileUtils.isSymlink(file)) {
            for (File f : FileUtils.listFiles(file)) {
                FileUtils.deleteFileSafely(f);
            }
        }
        return file.delete();
    }

    public static boolean deleteDirectoryFiles(File file) {
        boolean result = false;
        if (file.isDirectory()) {
            File[] files;
            for (File file2 : files = FileUtils.listFiles(file)) {
                if (!file2.isFile() || !FileUtils.deleteFile(file2)) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean deleteDirectoryFilesSafely(File file) throws IOException {
        boolean result = false;
        if (file.isDirectory() && !FileUtils.isSymlink(file)) {
            for (File f : FileUtils.listFiles(file)) {
                if (!f.isFile() || !FileUtils.deleteFileSafely(f)) continue;
                result = true;
            }
        }
        return result;
    }

    public static FileDeletionResults deleteFileWithResults(File file) {
        return FileUtils.retryingDeleteFileWithResults(file, new FileDeletionWithResultsFunction<RuntimeException>(){

            @Override
            public void invoke(FileDeletionResults results, File file) {
                FileUtils.deleteFileWithResults(results, file);
            }
        });
    }

    private static void deleteFileWithResults(FileDeletionResults results, File file) {
        if (file.isDirectory()) {
            File[] files = FileUtils.listFiles(file);
            if (files != null) {
                for (File f : files) {
                    FileUtils.deleteFileWithResults(results, f);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to list contents of " + file));
            }
        }
        long bytes = file.length();
        boolean deleteSuccessful = file.delete();
        if (deleteSuccessful || !file.exists()) {
            ++results.filesDeleted;
            results.bytesDeleted += bytes;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to delete " + file));
            }
            results.addFailedDeletionFile(file);
        }
    }

    public static FileDeletionResults deleteFileWithResultsSafely(File file) throws IOException {
        return FileUtils.retryingDeleteFileWithResults(file, new FileDeletionWithResultsFunction<IOException>(){

            @Override
            public void invoke(FileDeletionResults results, File file) throws IOException {
                FileUtils.deleteFileWithResultsSafely(results, file);
            }
        });
    }

    private static void deleteFileWithResultsSafely(FileDeletionResults results, File file) throws IOException {
        long length = file.length();
        boolean deleted = file.delete();
        if (deleted) {
            ++results.filesDeleted;
            results.bytesDeleted += length;
            return;
        }
        if (file.isDirectory()) {
            if (FileUtils.isSymlink(file)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed to delete " + file));
                }
                results.addFailedDeletionFile(file);
                return;
            }
            for (File f : FileUtils.listFiles(file)) {
                FileUtils.deleteFileWithResultsSafely(results, f);
            }
        }
        if (deleted = file.delete()) {
            ++results.filesDeleted;
            results.bytesDeleted += length;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to delete " + file));
            }
            results.addFailedDeletionFile(file);
        }
    }

    private static <E extends Throwable> FileDeletionResults retryingDeleteFileWithResults(File file, FileDeletionWithResultsFunction<E> deletionFunction) throws E {
        int attemptCount;
        FileDeletionResults finalResults = new FileDeletionResults();
        int currentFailureCount = 0x7FFFFFFE;
        int previousFailureCount = Integer.MAX_VALUE;
        for (attemptCount = 0; currentFailureCount > 0 && currentFailureCount < previousFailureCount && attemptCount < MAX_DELETE_ATTEMPT_COUNT; ++attemptCount) {
            if (attemptCount > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deletion attempt " + attemptCount + " failed; " + "making another in " + DELETE_RETRY_PAUSE + "ms."));
                }
                try {
                    Thread.sleep(DELETE_RETRY_PAUSE);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            FileDeletionResults results = new FileDeletionResults();
            deletionFunction.invoke(results, file);
            previousFailureCount = currentFailureCount;
            currentFailureCount = results.getFailedDeletionCount();
            finalResults.update(results);
        }
        if (log.isDebugEnabled()) {
            if (Thread.currentThread().isInterrupted()) {
                log.debug((Object)("Deletion was interrupted after " + attemptCount + " attempts"));
            }
            if (currentFailureCount <= 0) {
                log.debug((Object)("Deletion succeeded after " + attemptCount + " attempts"));
            } else if (currentFailureCount >= previousFailureCount) {
                log.debug((Object)("Deletion failed after " + attemptCount + " attempts: " + "no progress was made."));
            } else if (attemptCount >= MAX_DELETE_ATTEMPT_COUNT) {
                log.debug((Object)("Deletion failed after " + attemptCount + " attempts: " + "max attempt count reached."));
            } else {
                log.debug((Object)("Deletion failed after " + attemptCount + " attempts: " + "unknown reason."));
            }
        }
        return finalResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            File[] files;
            FileUtils.assertDirectory(dest);
            for (File file : files = FileUtils.listFiles(source)) {
                FileUtils.copyFile(file, new File(dest, file.getName()));
            }
        } else {
            File targetDir = dest.getParentFile();
            FileUtils.assertDirectory(targetDir);
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(source);
                out = new FileOutputStream(dest);
                int bytesRead = 0;
                byte[] bytes = new byte[1024];
                while ((bytesRead = in.read(bytes)) > 0) {
                    out.write(bytes, 0, bytesRead);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static File[] copyFiles(File source, File dest) throws IOException {
        ArrayList destFileList = new ArrayList();
        FileUtils.copyFiles(destFileList, source, dest);
        return destFileList.toArray(new File[destFileList.size()]);
    }

    private static void copyFiles(List destFileList, File source, File dest) throws IOException {
        if (source.isDirectory()) {
            File[] files;
            FileUtils.assertDirectory(dest);
            for (File file : files = FileUtils.listFiles(source)) {
                FileUtils.copyFiles(destFileList, file, new File(dest, file.getName()));
            }
        } else {
            File targetDir = dest.getParentFile();
            FileUtils.assertDirectory(targetDir);
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(dest);
            int bytesRead = 0;
            byte[] bytes = new byte[1024];
            while ((bytesRead = in.read(bytes)) > 0) {
                out.write(bytes, 0, bytesRead);
            }
            in.close();
            out.close();
            destFileList.add(dest);
        }
    }

    public static Iterator getDirectoryFiles(File directory) {
        ArrayList files = new ArrayList();
        FileUtils.getDirectoryFiles(files, directory, null, false);
        return files.iterator();
    }

    public static Iterator getDirectoryFiles(File directory, FileFilter filter) {
        ArrayList files = new ArrayList();
        FileUtils.getDirectoryFiles(files, directory, filter, false);
        return files.iterator();
    }

    public static Iterator getDirectoryFilesAndDirectories(File directory) {
        return FileUtils.getDirectoryFilesAndDirectories(directory, null);
    }

    public static Iterator getDirectoryFilesAndDirectories(File directory, FileFilter filter) {
        ArrayList files = new ArrayList();
        FileUtils.getDirectoryFiles(files, directory, filter, true);
        return files.iterator();
    }

    private static void getDirectoryFiles(List resultList, File directory, FileFilter filter, boolean includeDirs) {
        if (directory.isDirectory()) {
            File[] files;
            for (File file : files = FileUtils.listFiles(directory)) {
                if (file.isDirectory()) {
                    if (includeDirs) {
                        resultList.add(file);
                    }
                    FileUtils.getDirectoryFiles(resultList, file, filter, includeDirs);
                    continue;
                }
                if (filter != null && !filter.accept(file)) continue;
                resultList.add(file);
            }
        }
    }

    public static Iterator getFilteredDirectoryFilesAndDirectories(File directory, FileFilter filter) {
        ArrayList files = new ArrayList();
        FileUtils.getFilteredDirectoryFilesAndDirectories(files, directory, filter);
        return files.iterator();
    }

    private static void getFilteredDirectoryFilesAndDirectories(List resultList, File directory, FileFilter filter) {
        if (directory.isDirectory()) {
            File[] files;
            for (File file : files = FileUtils.listFiles(directory)) {
                if (filter == null || filter.accept(file)) {
                    resultList.add(file);
                }
                if (!file.isDirectory()) continue;
                FileUtils.getFilteredDirectoryFilesAndDirectories(resultList, file, filter);
            }
        }
    }

    public static Iterator getDirectorySubDirectories(File directory) {
        ArrayList dirList = new ArrayList();
        if (directory.isDirectory()) {
            FileUtils.getDirectorySubDirectories(dirList, directory);
        }
        return dirList.iterator();
    }

    private static void getDirectorySubDirectories(List dirList, File directory) {
        File[] files = directory.listFiles(subDirectoryFilter);
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                dirList.add(file);
                FileUtils.getDirectorySubDirectories(dirList, file);
            }
        }
    }

    public static boolean isAbsolutePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path parameter must not be null.");
        }
        boolean absolute = false;
        if (path.startsWith("/")) {
            absolute = true;
        }
        if (path.startsWith(File.separator + File.separator)) {
            absolute = true;
        }
        if (path.indexOf(":" + File.separator) == 1) {
            absolute = true;
        }
        return absolute;
    }

    public static String getNameMinusExtension(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(".");
        name = name.substring(0, index);
        return name;
    }

    public static String getRelativeFileName(File directory, File file) {
        if (directory == null) {
            throw new IllegalArgumentException("The parameter directory must be non-null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("The parameter file must be non-null.");
        }
        String directoryName = FileUtils.getNormalizedName(directory);
        String fileName = FileUtils.getNormalizedName(file);
        if (fileName.equals(directoryName)) {
            return ".";
        }
        if (fileName.startsWith(directoryName)) {
            return fileName.substring(directoryName.length() + 1);
        }
        StringBuffer path = new StringBuffer();
        for (File dirParent = FileUtils.getParentDirectory(directory); dirParent != null && dirParent.exists(); dirParent = dirParent.getParentFile()) {
            path.append("..");
            path.append(File.separator);
            directoryName = FileUtils.getNormalizedName(dirParent);
            if (!fileName.startsWith(directoryName)) continue;
            path.append(file.getName());
            return path.toString();
        }
        throw new IllegalArgumentException("No relative path exists.");
    }

    public static String getNormalizedName(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The parameter file must be non-null.");
        }
        String name = file.getAbsolutePath();
        return FileUtils.getNormalizedName(name);
    }

    public static String getNormalizedName(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The parameter path must be non-null.");
        }
        path = FileUtils.fixFileSeparator(path);
        boolean isAbsolute = FileUtils.isAbsolutePath(path);
        boolean isUNC = FileUtils.isUncPath(path);
        boolean trailingSlash = path.endsWith(File.separator);
        Character drive = null;
        if (path.length() > 2 && path.charAt(1) == ':' && Character.isLetter(path.charAt(0))) {
            drive = Character.valueOf(path.charAt(0));
            path = path.substring(2);
        }
        Stack<String> nameStack = new Stack<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, File.separator, false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("..")) {
                if (nameStack.isEmpty() || ((String)nameStack.peek()).equals("..")) {
                    if (isAbsolute) continue;
                    nameStack.push(token);
                    continue;
                }
                nameStack.pop();
                continue;
            }
            if (token.equals(".")) continue;
            nameStack.push(token);
        }
        StringBuilder normal = new StringBuilder();
        if (drive != null) {
            normal.append(drive);
            normal.append(':');
        }
        if (isAbsolute) {
            normal.append(File.separator);
            if (isUNC) {
                normal.append(File.separator);
            }
        }
        for (int i = 0; i < nameStack.size(); ++i) {
            String part = (String)nameStack.get(i);
            normal.append(part);
            if (i == nameStack.size() - 1) continue;
            normal.append(File.separatorChar);
        }
        String result = normal.toString();
        if (result.length() == 0) {
            result = ".";
        }
        if (trailingSlash && !result.endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    private static boolean isUncPath(String path) {
        boolean result = false;
        if (path.startsWith(File.separator + File.separator)) {
            if (path.length() == 2) {
                result = true;
            } else if (path.charAt(2) != File.separatorChar) {
                result = true;
            }
        }
        return result;
    }

    public static String fixFileSeparator(String filename) {
        String name = filename;
        if (name != null) {
            name = name.replace('/', File.separatorChar);
            name = name.replace('\\', File.separatorChar);
        }
        return name;
    }

    public static File getParentDirectory(File file) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("File is null or does not exist.");
        }
        String filename = FileUtils.getNormalizedName(file);
        int index = filename.lastIndexOf(File.separator);
        if (index > 0) {
            File parent = new File(filename.substring(0, index));
            return parent;
        }
        return null;
    }

    public static String getBytes(long size) {
        return FileUtils.getBytes(size, Locale.getDefault());
    }

    public static String getBytes(File file) {
        return FileUtils.getBytes(file, Locale.getDefault());
    }

    public static String getBytes(File file, Locale locale) {
        return FileUtils.getBytes(file.length(), locale);
    }

    public static String getBytes(long size, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(2);
        return format.format(size) + " bytes";
    }

    public static String getKiloBytes(long size) {
        return FileUtils.getKiloBytes(size, Locale.getDefault());
    }

    public static String getKiloBytes(File file) {
        return FileUtils.getKiloBytes(file.length());
    }

    public static String getKiloBytes(File file, Locale locale) {
        return FileUtils.getKiloBytes(file.length(), locale);
    }

    public static String getKiloBytes(long size, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(2);
        return format.format((double)size / 1024.0) + " KB";
    }

    public static String getMegaBytes(long size) {
        return FileUtils.getMegaBytes(size, Locale.getDefault());
    }

    public static String getMegaBytes(File file) {
        return FileUtils.getMegaBytes(file.length());
    }

    public static String getMegaBytes(File file, Locale locale) {
        return FileUtils.getMegaBytes(file.length(), locale);
    }

    public static String getMegaBytes(long size, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(2);
        return format.format((double)size / 1048576.0) + " MB";
    }

    public static String getGigaBytes(long size) {
        return FileUtils.getGigaBytes(size, Locale.getDefault());
    }

    public static String getGigaBytes(File file) {
        return FileUtils.getGigaBytes(file.length());
    }

    public static String getGigaBytes(File file, Locale locale) {
        return FileUtils.getGigaBytes(file.length(), locale);
    }

    public static String getGigaBytes(long size, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(2);
        return format.format((double)size / 1.073741824E9) + " GB";
    }

    public static String getNearestBytes(long size) {
        return FileUtils.getNearestBytes(size, Locale.getDefault());
    }

    public static String getNearestBytes(File file) {
        return FileUtils.getNearestBytes(file.length());
    }

    public static String getNearestBytes(File file, Locale locale) {
        return FileUtils.getNearestBytes(file.length(), locale);
    }

    public static String getNearestBytes(long size, Locale locale) {
        if ((double)size >= 1.073741824E9) {
            return FileUtils.getGigaBytes(size, locale);
        }
        if ((double)size >= 1048576.0) {
            return FileUtils.getMegaBytes(size, locale);
        }
        if ((double)size >= 1024.0) {
            return FileUtils.getKiloBytes(size, locale);
        }
        return FileUtils.getBytes(size, locale);
    }

    public static String getRelativePath(List files) {
        return FileUtils.getRelativePath(FileUtils.getCWD(), files);
    }

    public static String getRelativePath(File directory, List files) {
        if (files == null) {
            return "";
        }
        return FileUtils.getRelativePath(directory, files.iterator());
    }

    public static String getRelativePath(Iterator files) {
        return FileUtils.getRelativePath(FileUtils.getCWD(), files);
    }

    public static String getRelativePath(File directory, Iterator files) {
        if (files == null || !files.hasNext()) {
            return "";
        }
        StringBuffer path = new StringBuffer("");
        boolean first = true;
        while (files.hasNext()) {
            File file = (File)files.next();
            if (first) {
                first = false;
            } else {
                path.append(File.pathSeparator);
            }
            path.append(FileUtils.getRelativeFileName(directory, file));
        }
        return path.toString();
    }

    public static String getRelativePath(File baseDirectory, File file) throws IOException {
        String filePath;
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException("The parameter baseDirectory must be a directory!");
        }
        String basePath = baseDirectory.getCanonicalPath();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        if (!(filePath = file.getCanonicalPath()).startsWith(basePath)) {
            throw new IllegalArgumentException("The file '" + filePath + "' does not begin with the base directory '" + basePath + "'.");
        }
        return filePath.substring(basePath.length());
    }

    public static String getAbsolutePath(List files) {
        if (files == null) {
            return "";
        }
        return FileUtils.getAbsolutePath(files.iterator());
    }

    public static String getAbsolutePath(Iterator files) {
        if (files == null) {
            return "";
        }
        StringBuffer path = new StringBuffer("");
        boolean first = true;
        while (files.hasNext()) {
            File file = (File)files.next();
            if (first) {
                first = false;
            } else {
                path.append(File.pathSeparator);
            }
            path.append(FileUtils.getNormalizedName(file));
        }
        return path.toString();
    }

    public static File getCWD() {
        return new File(".");
    }

    public static void expandArchive(File archive, File deployDir) throws Exception {
        ZipFile zipFile = null;
        ZipEntry zipEntry = null;
        try {
            zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                zipEntry = en.nextElement();
                String name = Paths.forceRelativePath((String)zipEntry.getName());
                if (!Paths.isPathSafe((String)name)) {
                    throw new UnsafePathException("Unsafe path: " + zipEntry.getName());
                }
                if (zipEntry.isDirectory()) {
                    File zipDir = new File(deployDir, name);
                    if (zipDir.exists()) continue;
                    zipDir.mkdirs();
                    continue;
                }
                File fileOutput = new File(deployDir, name);
                fileOutput.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(fileOutput);
                InputStream is = zipFile.getInputStream(zipEntry);
                int bytesRead = 0;
                byte[] bytes = new byte[1024];
                while ((bytesRead = is.read(bytes)) > 0) {
                    ((OutputStream)os).write(bytes, 0, bytesRead);
                }
                is.close();
                ((OutputStream)os).close();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ioe) {
                    System.err.println("Expanded archive not closed: " + archive.getName());
                }
            }
        }
    }

    public static boolean compareFiles(File a, File b) throws IOException {
        boolean result = false;
        if (a == b) {
            result = true;
        } else if (a.equals(b)) {
            result = true;
        } else if (a.getCanonicalPath().equals(b.getCanonicalPath())) {
            result = true;
        } else if (a.isFile() && b.isFile()) {
            result = FileUtils.compareFileContents(a, b);
        } else if (a.isDirectory() && b.isDirectory()) {
            result = FileUtils.compareDirectoryContents(a, b);
        }
        return result;
    }

    public static boolean compareFiles(String a, String b) throws IOException {
        return FileUtils.compareFiles(new File(a), new File(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFileContents(File a, File b) throws IOException {
        boolean result = false;
        if (!a.isFile() || !b.isFile()) {
            throw new IllegalArgumentException("Arguments must be files");
        }
        if (a.length() != b.length()) {
            result = false;
        }
        FileInputStream inputStreamA = null;
        FileInputStream inputStreamB = null;
        try {
            int bytesReadA;
            inputStreamA = new FileInputStream(a.getAbsoluteFile());
            inputStreamB = new FileInputStream(b.getAbsoluteFile());
            int BLOCK_SIZE = 65536;
            byte[] bufferA = new byte[65536];
            byte[] bufferB = new byte[65536];
            do {
                int bytesReadB;
                boolean bl = result = (bytesReadA = inputStreamA.read(bufferA)) == (bytesReadB = inputStreamB.read(bufferB)) && Arrays.equals(bufferA, bufferB);
            } while (result && bytesReadA > -1);
        }
        finally {
            if (inputStreamA != null) {
                try {
                    inputStreamA.close();
                }
                catch (Exception e) {}
            }
            if (inputStreamB != null) {
                try {
                    inputStreamB.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFileContents(File a, File b, boolean ignoreWhiteSpace) throws IOException {
        boolean result = false;
        if (!a.isFile() || !b.isFile()) {
            throw new IllegalArgumentException("Arguments must be files");
        }
        if (a.length() != b.length() && !ignoreWhiteSpace) {
            result = false;
        }
        InputStream inputStreamA = null;
        InputStream inputStreamB = null;
        try {
            int nextByteA;
            inputStreamA = new BufferedInputStream(new FileInputStream(a.getAbsoluteFile()), 65536);
            inputStreamB = new BufferedInputStream(new FileInputStream(b.getAbsoluteFile()), 65536);
            do {
                nextByteA = inputStreamA.read();
                int nextByteB = inputStreamB.read();
                if (ignoreWhiteSpace) {
                    while (Character.isWhitespace((char)nextByteA) && nextByteA != -1) {
                        nextByteA = inputStreamA.read();
                    }
                    while (Character.isWhitespace((char)nextByteB) && nextByteB != -1) {
                        nextByteB = inputStreamB.read();
                    }
                }
                boolean bl = result = nextByteA == nextByteB;
            } while (result && nextByteA > -1);
        }
        finally {
            if (inputStreamA != null) {
                try {
                    inputStreamA.close();
                }
                catch (Exception e) {}
            }
            if (inputStreamB != null) {
                try {
                    inputStreamB.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static boolean compareFileContents(String a, String b) throws IOException {
        return FileUtils.compareFileContents(new File(a), new File(b));
    }

    public static boolean compareDirectoryContents(File a, File b) throws IOException {
        boolean result = true;
        if (!a.isDirectory() || !b.isDirectory()) {
            throw new IllegalArgumentException("Arguments must be directories");
        }
        List<File> aElements = Arrays.asList(FileUtils.listFiles(a));
        List<File> bElements = Arrays.asList(FileUtils.listFiles(b));
        if (aElements.size() != bElements.size()) {
            result = false;
        }
        Collections.sort(aElements);
        Collections.sort(bElements);
        Iterator<File> i = aElements.iterator();
        Iterator<File> j = bElements.iterator();
        while (i.hasNext() && j.hasNext()) {
            File a1 = i.next();
            File b1 = j.next();
            if (!a1.getName().equals(b1.getName())) {
                result = false;
                break;
            }
            if (FileUtils.compareFiles(a1, b1)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean compareDirectoryContents(String a, String b) throws IOException {
        return FileUtils.compareDirectoryContents(new File(a), new File(b));
    }

    public static File[] getFilesRecursively(File base, FileFilter filter) {
        if (base == null) {
            throw new NullPointerException("base is null");
        }
        boolean traceEnabled = LogUtil.isTraceEnabled((Logger)log);
        if (traceEnabled) {
            LogUtil.logTrace((Logger)log, (Object)("getFilesRecursively - base directory: " + base));
            if (filter instanceof DirectoryFileFilter) {
                DirectoryFileFilter dirFilter = (DirectoryFileFilter)filter;
                LogUtil.logTrace((Logger)log, (Object)("getFilesRecursively - filter base dir: " + dirFilter.getBaseDir()));
                LogUtil.logTrace((Logger)log, (Object)("getFilesRecursively - include rules: " + dirFilter.getIncludes().length));
                for (String inc : dirFilter.getIncludes()) {
                    LogUtil.logTrace((Logger)log, (Object)("getFilesRecursively - including: " + inc));
                }
                LogUtil.logTrace((Logger)log, (Object)("getFilesRecursively - exclude rules: " + dirFilter.getExcludes().length));
                for (String exc : dirFilter.getExcludes()) {
                    LogUtil.logTrace((Logger)log, (Object)("getFilesRecursively - excluding: " + exc));
                }
            }
        }
        ArrayList<File> fileList = new ArrayList<File>();
        LinkedList<File> directoryList = new LinkedList<File>();
        directoryList.add(base);
        while (directoryList.size() > 0) {
            ListIterator<File> directoryIter = directoryList.listIterator(directoryList.size());
            while (directoryIter.hasPrevious()) {
                File directory = (File)directoryIter.previous();
                if (traceEnabled) {
                    LogUtil.logTrace((Logger)log, (Object)("getFilesRecursively - directory: " + directory));
                }
                directoryIter.remove();
                File[] fileArray = FileUtils.listFiles(directory);
                if (fileArray == null) continue;
                if (traceEnabled) {
                    LogUtil.logTrace((Logger)log, (Object)("getFilesRecursively - directory files: " + fileArray.length));
                }
                for (File file : fileArray) {
                    if (traceEnabled) {
                        LogUtil.logTrace((Logger)log, (Object)("getFilesRecursively - comparing file: " + file));
                    }
                    if (filter == null || filter.accept(file)) {
                        fileList.add(file);
                    }
                    if (!file.isDirectory()) continue;
                    directoryIter.add(file);
                }
            }
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public static File[] getFilesRecursively(File base) {
        return FileUtils.getFilesRecursively(base, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileToOutput(File file, OutputStream output) throws IOException {
        if (file == null) {
            throw new NullPointerException("File was null");
        }
        if (output == null) {
            throw new NullPointerException("Output Stream was null");
        }
        byte[] buffer = new byte[4096];
        int len = 0;
        FileInputStream input = new FileInputStream(file.getAbsolutePath());
        try {
            while ((len = ((InputStream)input).read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, len);
            }
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputToFile(InputStream input, File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File was null");
        }
        if (input == null) {
            throw new NullPointerException("Input Stream was null");
        }
        file.getParentFile().mkdirs();
        file.createNewFile();
        byte[] buffer = new byte[4096];
        int len = 0;
        FileOutputStream output = new FileOutputStream(file);
        try {
            while ((len = input.read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, len);
            }
        }
        finally {
            output.close();
            input.close();
        }
    }

    public static long getSize(File file) {
        if (file == null) {
            throw new NullPointerException("File was null");
        }
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        if (file.isDirectory()) {
            long total = 0L;
            Iterator itr = FileUtils.getDirectoryFiles(file);
            while (itr.hasNext()) {
                File tempFile = (File)itr.next();
                total += tempFile.length();
            }
            return total;
        }
        throw new IllegalStateException("Problem encountered while determing file size for " + file.getPath());
    }

    public static String[] getFileArray(File baseDir, String[] includePatternArray, String[] excludePatternArray) {
        baseDir = baseDir.getAbsoluteFile();
        DirectoryFileFilter fileFilter = DirectoryFileFilter.getFilter(baseDir);
        if (includePatternArray != null) {
            fileFilter.addIncludes(includePatternArray);
        }
        if (excludePatternArray != null) {
            fileFilter.addExcludes(excludePatternArray);
        }
        Iterator fileIterator = FileUtils.getDirectoryFiles(baseDir, fileFilter);
        ArrayList<String> fileNameList = new ArrayList<String>();
        while (fileIterator.hasNext()) {
            File file = (File)fileIterator.next();
            String path = file.getAbsolutePath();
            path = path.substring(baseDir.getAbsolutePath().length());
            fileNameList.add(path);
        }
        String[] fileArray = new String[fileNameList.size()];
        fileNameList.toArray(fileArray);
        return fileArray;
    }

    private static File[] listFiles(File directory) {
        File[] files;
        File[] fileArray = files = directory == null ? null : directory.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    public static String readlink(File path) throws IOException {
        if (Java7Initializer.readSymbolicLink != null) {
            LogUtil.logTrace((Logger)log, (Object)"Using java7+ implementation of readlink");
            try {
                Object pathObj = Java7Initializer.toPath.invoke((Object)path, new Object[0]);
                pathObj = Java7Initializer.readSymbolicLink.invoke(null, pathObj);
                return pathObj.toString();
            }
            catch (IllegalArgumentException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (Java7Initializer.NotLinkException.isInstance(cause)) {
                    return null;
                }
                if (cause instanceof UnsupportedOperationException) {
                    return null;
                }
                if (cause instanceof IOException && !UnixInitializer.unix.isUnix()) {
                    return null;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw (IOException)new IOException("Could not read link value of " + path).initCause(cause);
            }
        }
        LogUtil.logTrace((Logger)log, (Object)"Using pre-java7 implementation of readlink");
        String linkPath = null;
        if (UnixInitializer.unix.isUnix()) {
            if (FileUtils.isSymlink(path)) {
                try {
                    linkPath = UnixInitializer.unix.readlink(path);
                }
                catch (IOException e) {
                    throw (IOException)new IOException("Unable to resolve link for " + path).initCause(e);
                }
                if (linkPath == null) {
                    throw new IOException("Unknown file type for " + path);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Path " + path + " is a symlink to " + linkPath));
                }
            }
        } else {
            LogUtil.logTrace((Logger)log, (Object)("Skipping link resolution for path " + path + ": not on unix"));
        }
        return linkPath;
    }

    public static boolean isSymlink(File path) throws IOException {
        boolean pathIsNotCanonical;
        if (Java7Initializer.isSymbolicLink != null) {
            LogUtil.logTrace((Logger)log, (Object)"Using java7+ implementation of isSymlink");
            try {
                Object pathObj = Java7Initializer.toPath.invoke((Object)path, new Object[0]);
                Boolean result = (Boolean)Java7Initializer.isSymbolicLink.invoke(null, pathObj);
                return result;
            }
            catch (IllegalArgumentException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw (IOException)new IOException("Could not read link value of " + path).initCause(cause);
            }
        }
        LogUtil.logTrace((Logger)log, (Object)"Using pre-java7 implementation of isSymlink");
        boolean pathDoesNotExist = !path.exists();
        boolean bl = pathIsNotCanonical = !FileUtils.isNameCanonical(path);
        if (LogUtil.isTraceEnabled((Logger)log)) {
            if (pathDoesNotExist || pathIsNotCanonical) {
                if (pathDoesNotExist) {
                    LogUtil.logTrace((Logger)log, (Object)(path + " doesn't exist - assuming symlink to non-existent file"));
                }
                if (pathIsNotCanonical) {
                    File canonical = path.getCanonicalFile();
                    LogUtil.logTrace((Logger)log, (Object)(path + " is not canonical in the name (" + canonical + ") - assuming symlink"));
                }
            } else {
                LogUtil.logTrace((Logger)log, (Object)("Path " + path + " is not a symlink"));
            }
        }
        return pathDoesNotExist || pathIsNotCanonical;
    }

    private static boolean isNameCanonical(File path) throws IOException {
        File partialCanonical = FileUtils.canonicalizeParent(path);
        File canonical = path.getCanonicalFile();
        if (LogUtil.isTraceEnabled((Logger)log)) {
            LogUtil.logTrace((Logger)log, (Object)("             Path: " + path));
            LogUtil.logTrace((Logger)log, (Object)("Partial canonical: " + partialCanonical));
            LogUtil.logTrace((Logger)log, (Object)("        Canonical: " + canonical));
        }
        return partialCanonical.equals(canonical);
    }

    private static File canonicalizeParent(File path) throws IOException {
        File parent = path.getAbsoluteFile().getParentFile();
        if (parent == null) {
            return path;
        }
        File canonicalParent = parent.getCanonicalFile();
        return new File(canonicalParent, path.getName());
    }

    private FileUtils() {
    }

    private static final class Java7Initializer {
        static final Method toPath;
        static final Method isSymbolicLink;
        static final Method readSymbolicLink;
        static final Class<?> NotLinkException;

        private Java7Initializer() {
        }

        static {
            Method tp = null;
            Method is = null;
            Method rs = null;
            Class<?> nl = null;
            if (!DISABLE_JAVA_7_FEATURES) {
                try {
                    tp = File.class.getMethod("toPath", new Class[0]);
                    Class<?> path = Class.forName("java.nio.file.Path");
                    Class<?> files = Class.forName("java.nio.file.Files");
                    is = files.getMethod("isSymbolicLink", path);
                    rs = files.getMethod("readSymbolicLink", path);
                    nl = Class.forName("java.nio.file.NotLinkException");
                }
                catch (Throwable t) {
                    tp = null;
                    is = null;
                    rs = null;
                    nl = null;
                }
            }
            toPath = tp;
            isSymbolicLink = is;
            readSymbolicLink = rs;
            NotLinkException = nl;
        }
    }

    private static final class UnixInitializer {
        static final Unix unix = new Unix();

        private UnixInitializer() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface FileDeletionWithResultsFunction<E extends Throwable> {
        public void invoke(FileDeletionResults var1, File var2) throws E;
    }
}

