/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.bm;

import com.ibm.uclab.csrepl.bm.BmConnector;
import com.ibm.uclab.csrepl.exceptions.AuthenticationException;
import com.ibm.uclab.csrepl.http.HttpClientWrapper;
import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import com.ibm.uclab.csrepl.streams.AbortingInputStream;
import com.ibm.uclab.csrepl.streams.HashCheckingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class BmConnectorHttp
implements BmConnector {
    private static final Logger log = Logger.getLogger(BmConnectorHttp.class);
    private static final String CLIENT_ID_HEADER = "X-Codestation-Client-ID";
    private static final String DIGEST_HEADER = "X-Codestation-Digest-Algorithm";
    private final Lifecycle lifecycle;
    private final HttpClientWrapper client;
    private final String peerUrl;

    public BmConnectorHttp(HttpClientWrapper client, String peerUrl) {
        while (peerUrl.endsWith("/")) {
            peerUrl = peerUrl.substring(0, peerUrl.length() - 1);
        }
        this.lifecycle = new Lifecycle(this, new LifecycleEventListener(){

            @Override
            public void onStart() {
                BmConnectorHttp.this.start0();
            }

            @Override
            public void onStop() {
                BmConnectorHttp.this.stop0();
            }
        });
        this.peerUrl = peerUrl;
        this.client = client;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.peerUrl + "]";
    }

    @Override
    public void start() {
        this.lifecycle.start();
    }

    @Override
    public void stop() {
        this.lifecycle.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream openBlob(UUID localId, UUID blobId) throws IOException {
        String path = this.peerUrl + "/bm/blob/" + blobId.toString();
        try {
            HttpGet req = new HttpGet(path);
            req.setHeader(CLIENT_ID_HEADER, localId.toString());
            req.setHeader(DIGEST_HEADER, "MD5");
            boolean consumeEntity = true;
            HttpResponse res = this.client.execute((HttpUriRequest)req);
            try {
                StatusLine status = res.getStatusLine();
                switch (status.getStatusCode()) {
                    case 401: {
                        if (!log.isDebugEnabled()) throw new AuthenticationException("Cannot authenticate with server: " + this.peerUrl);
                        log.debug((Object)String.format("Requested failed with unacceptable response: %s: %03d %s", req.getURI(), status.getStatusCode(), status.getReasonPhrase()));
                        throw new AuthenticationException("Cannot authenticate with server: " + this.peerUrl);
                    }
                    case 200: {
                        HttpEntity ent = res.getEntity();
                        InputStream in = null;
                        if (ent != null) {
                            in = ent.getContent();
                        }
                        if (ent == null || in == null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Request succeeded without content: %s: %03d %s", req.getURI(), status.getStatusCode(), status.getReasonPhrase()));
                            }
                            InputStream inputStream = null;
                            return inputStream;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Request succeeded with content: %s: %03d %s", req.getURI(), status.getStatusCode(), status.getReasonPhrase()));
                        }
                        in = new AbortingInputStream((HttpRequestBase)req, in);
                        MessageDigest dig = this.getResponseDigest(res);
                        if (dig != null) {
                            in = new HashCheckingInputStream(in, dig);
                        }
                        consumeEntity = false;
                        InputStream inputStream = in;
                        return inputStream;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Request failed with unacceptable response: %s: %03d %s", req.getURI(), status.getStatusCode(), status.getReasonPhrase()));
                }
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                if (consumeEntity) {
                    EntityUtils.consumeQuietly((HttpEntity)res.getEntity());
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void start0() {
        this.client.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        this.client.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }

    private MessageDigest getResponseDigest(HttpResponse res) throws IOException {
        Header h = res.getFirstHeader(DIGEST_HEADER);
        if (h == null) {
            return null;
        }
        String v = h.getValue();
        if (v == null) {
            return null;
        }
        try {
            return MessageDigest.getInstance(v);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unsupported digest: " + v);
        }
    }
}

