/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.lifecycle;

import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import com.ibm.uclab.csrepl.lifecycle.LifecycleStoppedException;
import java.util.WeakHashMap;

public class Lifecycle {
    private static WeakHashMap<Thread, Boolean> workerThreads = new WeakHashMap();
    private final Object sync;
    private final LifecycleEventListener listener;
    private boolean started;
    private boolean stopped;
    private int startCount;

    public static synchronized void setWorkerThread(boolean workerThread) {
        Thread thread = Thread.currentThread();
        if (workerThread) {
            workerThreads.put(thread, true);
        } else {
            workerThreads.remove(thread);
        }
    }

    private static synchronized boolean isWorkerThread() {
        Boolean wt = workerThreads.get(Thread.currentThread());
        if (wt == null) {
            return false;
        }
        return wt;
    }

    static synchronized int getWorkerThreadCount() {
        return workerThreads.size();
    }

    public Lifecycle(Object sync, LifecycleEventListener listener) {
        if (sync == null) {
            sync = this;
        }
        this.sync = sync;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.sync;
        synchronized (object) {
            if (this.stopped) {
                if (Lifecycle.isWorkerThread()) {
                    throw new LifecycleStoppedException();
                }
                throw new IllegalStateException("Stopped");
            }
            if (!this.started) {
                this.started = true;
                if (this.listener != null) {
                    this.listener.onStart();
                }
            }
            ++this.startCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.started) {
                throw new IllegalStateException("Not started");
            }
            if (this.startCount == 0) {
                return;
            }
            --this.startCount;
            if (this.startCount == 0) {
                this.stopped = true;
                if (this.listener != null) {
                    this.listener.onStop();
                }
            }
        }
    }

    public Object getSync() {
        return this.sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkActive() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isStarted()) {
                throw new IllegalStateException("Not started");
            }
            if (this.isStopped()) {
                if (Lifecycle.isWorkerThread()) {
                    throw new LifecycleStoppedException();
                }
                throw new IllegalStateException("Stopped");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.sync;
        synchronized (object) {
            return this.started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.sync;
        synchronized (object) {
            return this.stopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.sync;
        synchronized (object) {
            return this.started && !this.stopped;
        }
    }
}

