/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.rest;

import com.ibm.uclab.csrepl.asm.ArtifactSetManager;
import com.ibm.uclab.csrepl.asm.ArtifactSetManagerLookup;
import com.ibm.uclab.csrepl.asm.security.AsmResourceSecurity;
import com.ibm.uclab.csrepl.asm.security.AsmResourceSecurityLookup;
import com.ibm.uclab.csrepl.exceptions.CodestationSecurityException;
import com.ibm.uclab.csrepl.rest.ArtifactsResource;
import com.ibm.uclab.csrepl.rest.Errors;
import com.ibm.uclab.csrepl.rest.IDMappingEntity;
import com.ibm.uclab.csrepl.rest.UUIDParam;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="asm")
public class AsmResource {
    private static final Logger log = Logger.getLogger(ArtifactsResource.class);
    private static final AtomicLong counter = new AtomicLong();
    private final ArtifactSetManager asm;
    private final AsmResourceSecurity security;

    public AsmResource() {
        this(ArtifactSetManagerLookup.get(), AsmResourceSecurityLookup.get());
    }

    public AsmResource(@Context ArtifactSetManager asm, @Context AsmResourceSecurity security) {
        this.asm = asm;
        this.security = security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public String getStatus() {
        String string;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../asm/status", op));
        }
        try {
            this.getASM();
            string = "OK";
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("[op=%d] Complete", op));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return string;
    }

    @GET
    @Path(value="mappings")
    @Produces(value={"text/plain"})
    public Response getMappings() throws Exception {
        Response response;
        long op = counter.getAndIncrement();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] GET .../asm/mappings", op));
        }
        try {
            this.assertCanGetMappings();
            ArtifactSetManager asm = this.getASM();
            IDMappingEntity entity = new IDMappingEntity(asm);
            Map<String, String> charset = Collections.singletonMap("charset", "UTF-8");
            MediaType type = new MediaType("text", "plain", charset);
            response = Response.ok((Object)entity, (MediaType)type).build();
        }
        catch (CodestationSecurityException e) {
            try {
                throw Errors.forbidden(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("[op=%d] Complete", op));
                }
                throw throwable;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("[op=%d] Complete", op));
        }
        return response;
    }

    /*
     * Exception decompiling
     */
    @GET
    @Path(value="artifactSet/{artifactSetId}")
    @Produces(value={"text/plain"})
    public Response get(@PathParam(value="artifactSetId") UUIDParam artifactSetId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @PUT
    @Path(value="artifactSet/{artifactSetId}")
    @Consumes(value={"text/plain"})
    public Response set(@PathParam(value="artifactSetId") UUIDParam artifactSetId, UUIDParam blobId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="compareAndSet")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response compareAndSet(@FormParam(value="artifactSetId") UUIDParam artifactSetId, @FormParam(value="oldBlobId") UUIDParam oldBlobId, @FormParam(value="newBlobId") UUIDParam newBlobId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ArtifactSetManager getASM() {
        if (this.asm == null) {
            throw Errors.serviceUnavailable("Artifact set manager unavailable");
        }
        return this.asm;
    }

    public synchronized AsmResourceSecurity getSecurity() {
        return this.security;
    }

    private void assertCanGetMappings() {
        AsmResourceSecurity security = this.getSecurity();
        if (security != null) {
            security.assertCanGetMappings();
        }
    }

    private void assertCanReadMapping(UUID artifactSetId) {
        AsmResourceSecurity security = this.getSecurity();
        if (security != null) {
            security.assertCanReadMapping(artifactSetId);
        }
    }

    private void assertCanCreateMapping(UUID artifactSetId) {
        AsmResourceSecurity security = this.getSecurity();
        if (security != null) {
            security.assertCanCreateMapping(artifactSetId);
        }
    }

    private void assertCanUpdateMapping(UUID artifactSetId) {
        AsmResourceSecurity security = this.getSecurity();
        if (security != null) {
            security.assertCanUpdateMapping(artifactSetId);
        }
    }
}

