/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.codestation2.common.aggregate;

import com.urbancode.codestation2.common.aggregate.Aggregate;
import com.urbancode.codestation2.common.aggregate.AggregateItemMeta;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AggregateItem
implements Comparable<AggregateItem>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int type;
    private final String path;
    private volatile String dataFileName;
    private final long offset;
    private final long length;
    private long lastModified;
    private String hash;
    private Integer unixMode;
    private String unixUser;
    private String unixGroup;
    private String charset;
    private String zosDeployType;
    private String zosDeployAction;
    private String zosContainerType;
    private String userAttributes;

    AggregateItem(AggregateItemMeta meta, String dataFileName, long offset, long length) {
        assert (Aggregate.isPathValid(meta.getPath()));
        this.type = meta.getTypeWithFlags();
        this.path = meta.getPath();
        this.dataFileName = dataFileName;
        this.offset = offset;
        this.length = length;
        this.updateFromMeta(meta);
    }

    AggregateItem(int typeWithFlags, String path, String dataFileName, long offset, long length) {
        assert (Aggregate.isPathValid(path));
        this.type = typeWithFlags;
        this.path = path;
        this.dataFileName = dataFileName;
        this.offset = offset;
        this.length = length;
    }

    public int getType() {
        int t = this.type;
        return t &= Integer.MAX_VALUE;
    }

    public int getTypeWithFlags() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isMetaOnly() {
        return (this.type & Integer.MIN_VALUE) != 0;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Integer getUnixMode() {
        return this.unixMode;
    }

    public void setUnixMode(Integer unixMode) {
        this.unixMode = unixMode;
    }

    public String getUnixUser() {
        return this.unixUser;
    }

    public void setUnixUser(String unixUser) {
        this.unixUser = unixUser;
    }

    public String getUnixGroup() {
        return this.unixGroup;
    }

    public void setUnixGroup(String unixGroup) {
        this.unixGroup = unixGroup;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getZosDeployType() {
        return this.zosDeployType;
    }

    public void setZosDeployType(String zosDeployType) {
        this.zosDeployType = zosDeployType;
    }

    public String getZosDeployAction() {
        return this.zosDeployAction;
    }

    public void setZosDeployAction(String zosDeployAction) {
        this.zosDeployAction = zosDeployAction;
    }

    public String getZosContainerType() {
        return this.zosContainerType;
    }

    public void setZosContainerType(String zosContainerType) {
        this.zosContainerType = zosContainerType;
    }

    public JSONObject getUserAttributes() {
        String ua = this.getUserAttributes0();
        if (ua == null) {
            return null;
        }
        try {
            return new JSONObject(ua);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUserAttributes(JSONObject userAttributes) {
        if (userAttributes == null) {
            this.setUserAttributes0(null);
            return;
        }
        this.setUserAttributes0(userAttributes.toString());
    }

    public AggregateItemMeta getMeta() {
        AggregateItemMeta meta = new AggregateItemMeta(this.type, this.path);
        meta.setLastModified(this.lastModified);
        meta.setHash(this.hash);
        meta.setUnixMode(this.unixMode);
        meta.setUnixUser(this.unixUser);
        meta.setUnixGroup(this.unixGroup);
        meta.setCharset(this.charset);
        meta.setZosDeployType(this.zosDeployType);
        meta.setZosDeployAction(this.zosDeployAction);
        meta.setZosContainerType(this.zosContainerType);
        meta.setUserAttributes0(this.userAttributes);
        return meta;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AggregateItem) {
            AggregateItem r = (AggregateItem)obj;
            return this.type == r.type && this.path.equals(r.path) && this.dataFileName.equals(r.dataFileName) && this.offset == r.offset && this.length == r.length;
        }
        return false;
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + this.type;
        hash = 31 * hash + this.path.hashCode();
        hash = 31 * hash + this.dataFileName.hashCode();
        hash = 31 * hash + (int)(this.offset ^ this.offset >>> 32);
        hash = 31 * hash + (int)(this.length ^ this.length >>> 32);
        return hash;
    }

    public String toString() {
        return String.format("FileItem{type=%s, path=%s, dataFileName=%s, offset=%d, length=%d}", Aggregate.typeToString(this.type), this.path, this.dataFileName, this.offset, this.length);
    }

    public String toLongString() {
        String hash = "<undefined>";
        if (this.hash != null) {
            hash = this.hash;
        }
        String lastModified = "<undefined>";
        if (this.lastModified != 0L) {
            lastModified = String.valueOf(this.lastModified);
        }
        String unixMode = "<undefined>";
        if (this.unixMode != null) {
            unixMode = String.format("%04o", this.unixMode);
        }
        String unixUser = "<undefined>";
        if (this.unixUser != null) {
            unixUser = this.unixUser;
        }
        String unixGroup = "<undefined>";
        if (this.unixGroup != null) {
            unixGroup = this.unixGroup;
        }
        String charset = "<undefined>";
        if (this.charset != null) {
            charset = this.charset;
        }
        String zosDeployType = "<undefined>";
        if (this.zosDeployType != null) {
            zosDeployType = this.zosDeployType;
        }
        String zosDeployAction = "<undefined>";
        if (this.zosDeployAction != null) {
            zosDeployAction = this.zosDeployAction;
        }
        String zosContainerType = "<undefined>";
        if (this.zosContainerType != null) {
            zosContainerType = this.zosContainerType;
        }
        String userAttributes = "<undefined>";
        if (this.userAttributes != null) {
            userAttributes = this.userAttributes;
        }
        return String.format("FileItem{%n  type=%s%n  path=%s%n  dataFileName=%s%n  offset=%d%n  length=%d%n  lastModified=%s%n  hash=%s%n  unixMode=%s%n  unixUser=%s%n  unixGroup=%s%n  charset=%s%n  zosDeployType=%s%n  zosDeployAction=%s%n  zosContainerType=%s%n  userAttributes=%s%n}", Aggregate.typeToString(this.type), this.path, this.dataFileName, this.offset, this.length, lastModified, hash, unixMode, unixUser, unixGroup, charset, zosDeployType, zosDeployAction, zosContainerType, userAttributes);
    }

    @Override
    public int compareTo(AggregateItem o) {
        int cmp = this.dataFileName.compareTo(o.dataFileName);
        if (cmp < 0) {
            return -1;
        }
        if (cmp > 0) {
            return 1;
        }
        if (this.offset < o.offset) {
            return -1;
        }
        if (this.offset > o.offset) {
            return 1;
        }
        return 0;
    }

    public File toFile(File base) {
        String rel = this.path;
        rel = rel.replaceFirst("^/+", "");
        rel = rel.replace('/', File.separatorChar);
        return new File(base, rel);
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    String getUserAttributes0() {
        return this.userAttributes;
    }

    void setUserAttributes0(String userAttributes) {
        this.userAttributes = userAttributes;
    }

    void updateFromMeta(AggregateItemMeta meta) {
        this.lastModified = meta.getLastModified();
        this.hash = meta.getHash();
        this.unixMode = meta.getUnixMode();
        this.unixUser = meta.getUnixUser();
        this.unixGroup = meta.getUnixGroup();
        this.charset = meta.getCharset();
        this.zosDeployType = meta.getZosDeployType();
        this.zosDeployAction = meta.getZosDeployAction();
        this.zosContainerType = meta.getZosContainerType();
        this.userAttributes = meta.getUserAttributes0();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private Object readResolve() throws ObjectStreamException {
        if (Aggregate.isPathValid(this.path)) {
            return this;
        }
        String ua = null;
        try {
            if (this.userAttributes != null) {
                ua = new JSONObject(this.userAttributes).toString();
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        String p = Aggregate.unsafeSanitize(this.path);
        AggregateItem r = new AggregateItem(this.type, p, this.dataFileName, this.offset, this.length);
        r.lastModified = this.lastModified;
        r.hash = this.hash;
        r.unixMode = this.unixMode;
        r.unixUser = this.unixUser;
        r.unixGroup = this.unixGroup;
        r.charset = this.charset;
        r.zosDeployType = this.zosDeployType;
        r.zosDeployAction = this.zosDeployAction;
        r.zosContainerType = this.zosContainerType;
        r.userAttributes = ua;
        return r;
    }

    static {
        StringBuilder b = new StringBuilder();
        b.append("com.");
        b.append("urbancode.");
        b.append("codestation2.");
        b.append("common.");
        b.append("aggregate.");
        b.append("AggregateItem");
        String expected = b.toString();
        String name = AggregateItem.class.getName();
        if (!name.equals(expected)) {
            throw new Error("Serialized class name changed: name=" + name + ", expected=" + expected);
        }
    }
}

