/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.bm;

import com.ibm.uclab.csrepl.blobstore.BlobInputSource;
import com.ibm.uclab.csrepl.blobstore.BlobSource;
import com.ibm.uclab.csrepl.blobstore.BlobStore;
import com.ibm.uclab.csrepl.bm.BlobManager;
import com.ibm.uclab.csrepl.bm.BmConnector;
import com.ibm.uclab.csrepl.bm.security.BmSecurity;
import com.ibm.uclab.csrepl.lifecycle.Lifecycle;
import com.ibm.uclab.csrepl.lifecycle.LifecycleEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.log4j.Logger;

public class BlobManagerImpl
implements BlobManager {
    private static final Logger log = Logger.getLogger(BlobManagerImpl.class);
    private final Lifecycle lifecycle;
    private final UUID id;
    private final BlobStore store;
    private BmConnector connector;
    private BmSecurity security;

    public BlobManagerImpl(UUID id, BlobStore store) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (store == null) {
            throw new NullPointerException("store");
        }
        this.lifecycle = new Lifecycle(this, new LifecycleEventListener(){

            @Override
            public void onStart() {
                BlobManagerImpl.this.start0();
            }

            @Override
            public void onStop() {
                BlobManagerImpl.this.stop0();
            }
        });
        this.id = id;
        this.store = store;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]";
    }

    @Override
    public void start() {
        this.lifecycle.start();
    }

    @Override
    public void stop() {
        this.lifecycle.stop();
    }

    public synchronized void setConnector(BmConnector connector) {
        if (this.lifecycle.isStopped()) {
            throw new IllegalStateException("Stopped");
        }
        if (this.connector != null) {
            throw new IllegalStateException("Connector set");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting connector: " + connector));
        }
        this.connector = connector;
        if (this.lifecycle.isStarted()) {
            connector.start();
        }
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public UUID addBlob(InputStream in) throws IOException {
        if (this.getConnector() != null) {
            throw new UnsupportedOperationException("Local modification disabled");
        }
        this.assertCanCreateBlob();
        return this.store.addBlob(in);
    }

    @Override
    public UUID addBlob(BlobInputSource in) throws IOException {
        if (this.getConnector() != null) {
            throw new UnsupportedOperationException("Local modification disabled");
        }
        this.assertCanCreateBlob();
        return this.store.addBlob(in);
    }

    @Override
    public void removeBlobLocal(UUID blobId) throws IOException {
        this.assertCanDeleteBlob(blobId);
        this.store.removeBlob(blobId);
    }

    @Override
    public InputStream openBlob(UUID blobId) throws IOException {
        this.assertCanReadBlob(blobId);
        InputStream blob = this.store.openBlob(blobId);
        if (blob != null) {
            return blob;
        }
        this.replicateBlob(blobId);
        return this.store.openBlob(blobId);
    }

    @Override
    public InputStream openBlobLocal(UUID blobId) throws IOException {
        this.assertCanReadBlob(blobId);
        return this.store.openBlob(blobId);
    }

    @Override
    public void replicateBlob(UUID blobId) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Replicating " + blobId));
        }
        if (this.store.hasBlob(blobId)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Blob present; terminating replication");
            }
            return;
        }
        this.assertCanCreateBlob();
        BlobSource source = this.createSource(blobId);
        if (source == null) {
            return;
        }
        this.store.startReplication(blobId, source);
    }

    @Override
    public void replicateBlobSync(UUID blobId) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Replicating " + blobId));
        }
        if (this.store.hasBlob(blobId)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Blob present; terminating replication");
            }
            return;
        }
        this.assertCanCreateBlob();
        BlobSource source = this.createSource(blobId);
        if (source == null) {
            return;
        }
        this.store.replicate(blobId, source);
    }

    @Override
    public InputStream replicateAndOpenBlob(UUID blobId) throws IOException {
        this.assertCanReadBlob(blobId);
        this.assertCanCreateBlob();
        this.replicateBlob(blobId);
        return this.store.openBlob(blobId);
    }

    @Override
    public long estimateDiskUsage(UUID id) throws IOException {
        this.assertCanReadBlob(id);
        return this.store.estimateDiskUsage(id);
    }

    public synchronized BmSecurity getSecurity() {
        return this.security;
    }

    public synchronized void setSecurity(BmSecurity security) {
        if (this.lifecycle.isStopped()) {
            throw new IllegalStateException("Stopped");
        }
        if (this.lifecycle.isStarted() && this.security != null) {
            throw new IllegalStateException("Security cannot change after start");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting security: " + security));
        }
        this.security = security;
        if (this.lifecycle.isStarted() && security != null) {
            security.start();
        }
    }

    synchronized BmConnector getConnector() {
        return this.connector;
    }

    private void start0() {
        this.store.start();
        if (this.security != null) {
            this.security.start();
        }
        if (this.connector != null) {
            this.connector.start();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": started"));
        }
    }

    private void stop0() {
        if (this.security != null) {
            this.security.stop();
        }
        if (this.connector != null) {
            this.connector.stop();
        }
        this.store.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": stopped"));
        }
    }

    private BlobSource createSource(final UUID blobId) {
        final BmConnector c = this.getConnector();
        if (c == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No remote connector; terminating replication");
            }
            return null;
        }
        return new BlobSource(){

            @Override
            public InputStream get() throws IOException {
                InputStream blob = c.openBlob(BlobManagerImpl.this.id, blobId);
                if (log.isTraceEnabled() && blob == null) {
                    log.trace((Object)("No remote blob " + BlobManagerImpl.this.id + "; terminating replication"));
                }
                return blob;
            }
        };
    }

    private synchronized void assertCanReadBlob(UUID blobId) {
        BmSecurity sec = this.getSecurity();
        if (sec != null) {
            sec.assertCanReadBlob(blobId);
        }
    }

    private synchronized void assertCanCreateBlob() {
        BmSecurity sec = this.getSecurity();
        if (sec != null) {
            sec.assertCanCreateBlob();
        }
    }

    private synchronized void assertCanDeleteBlob(UUID blobId) {
        BmSecurity sec = this.getSecurity();
        if (sec != null) {
            sec.assertCanDeleteBlob(blobId);
        }
    }
}

