/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uclab.csrepl.bm;

import com.ibm.uclab.csrepl.bm.BmConnectorHttp;
import com.ibm.uclab.csrepl.exceptions.AuthenticationException;
import com.ibm.uclab.csrepl.exceptions.AuthorizationException;
import com.ibm.uclab.csrepl.exceptions.ServerFailedException;
import com.ibm.uclab.csrepl.exceptions.ServerUnavailableException;
import com.ibm.uclab.csrepl.exceptions.UpstreamServerFailedException;
import com.ibm.uclab.csrepl.exceptions.UpstreamServerUnavailableException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

class Errors {
    private static final Logger log = Logger.getLogger(BmConnectorHttp.class);

    static IOException defaultErrorSwitch(UUID artifactSetId, CallResult result) {
        int status = result.res.getStatusLine().getStatusCode();
        switch (status) {
            case 401: {
                return Errors.notAuthenticated(artifactSetId, result);
            }
            case 403: {
                return Errors.notAuthorized(artifactSetId, result);
            }
            case 404: {
                return Errors.notFound(artifactSetId, result);
            }
            case 502: {
                return Errors.upstreamServerFailed(artifactSetId, result);
            }
            case 503: {
                return Errors.serverUnavailable(artifactSetId, result);
            }
            case 504: {
                return Errors.upstreamServerUnavailable(artifactSetId, result);
            }
        }
        if (status >= 500 && status < 600) {
            return Errors.serverFailed(artifactSetId, result);
        }
        return Errors.unacceptableResponse(result);
    }

    static ServerFailedException serverFailed(UUID artifactSetId, CallResult result) {
        return new ServerFailedException(Errors.formatErrorMessage("Server failed", artifactSetId, result));
    }

    static UpstreamServerFailedException upstreamServerFailed(UUID artifactSetId, CallResult result) {
        return new UpstreamServerFailedException(Errors.formatErrorMessage("Upstream server failed", artifactSetId, result));
    }

    static UpstreamServerUnavailableException upstreamServerUnavailable(UUID artifactSetId, CallResult result) {
        return new UpstreamServerUnavailableException(Errors.formatErrorMessage("Upstream server unavailable", artifactSetId, result));
    }

    static ServerUnavailableException serverUnavailable(UUID artifactSetId, CallResult result) {
        return new ServerUnavailableException(Errors.formatErrorMessage("Server unavailable", artifactSetId, result));
    }

    static AuthenticationException notAuthenticated(UUID artifactSetId, CallResult result) {
        return new AuthenticationException(Errors.formatErrorMessage("Authentication failed", artifactSetId, result));
    }

    static AuthorizationException notAuthorized(UUID artifactSetId, CallResult result) {
        return new AuthorizationException(Errors.formatErrorMessage("Not authorized", artifactSetId, result));
    }

    static FileNotFoundException notFound(UUID artifactSetId, CallResult result) {
        if (log.isDebugEnabled()) {
            StatusLine status = result.res.getStatusLine();
            String error = Errors.getErrorMessage(result.res);
            error = error == null ? "" : ": " + error;
            log.debug((Object)String.format("Request failed with not found: %s %s: %03d %s%s", result.method, result.reqUrl, status.getStatusCode(), status.getReasonPhrase(), error));
        }
        return new FileNotFoundException(String.format("Artifact set not found: %s%n%s URL: %s", artifactSetId, result.method, result.reqUrl));
    }

    static IOException unacceptableResponse(CallResult result) {
        String error = Errors.getErrorMessage(result.res);
        error = error == null ? "" : ": " + error;
        StatusLine status = result.res.getStatusLine();
        String message = String.format("Unacceptable response: %s %s: %03d %s%s", result.method, result.reqUrl, status.getStatusCode(), status.getReasonPhrase(), error);
        log.debug((Object)message);
        return new IOException(message);
    }

    private static String getErrorMessage(HttpResponse res) {
        try {
            HttpEntity ent = res.getEntity();
            if (ent == null) {
                return null;
            }
            Header hd = ent.getContentType();
            if (hd == null) {
                return null;
            }
            String val = hd.getValue();
            if (val == null) {
                return null;
            }
            ContentType ct = ContentType.parse((String)val);
            if (ct == null) {
                return null;
            }
            if (!"text/plain".equalsIgnoreCase(ct.getMimeType())) {
                return null;
            }
            return EntityUtils.toString((HttpEntity)ent);
        }
        catch (ParseException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String formatErrorMessage(String message, UUID artifactSetId, CallResult result) {
        if (log.isDebugEnabled()) {
            StatusLine status = result.res.getStatusLine();
            String error = Errors.getErrorMessage(result.res);
            error = error == null ? "" : ": " + error;
            log.debug((Object)String.format("Request failed: %s: %s %s: %03d %s%s", message, result.method, result.reqUrl, status.getStatusCode(), status.getReasonPhrase(), error));
        }
        return String.format("%s: %s%n%s URL: %s", message, artifactSetId, result.method, result.reqUrl);
    }

    private Errors() {
        throw new UnsupportedOperationException();
    }

    static class CallResult {
        final String method;
        final String reqUrl;
        final HttpRequestBase req;
        final HttpResponse res;

        CallResult(String method, String reqUrl, HttpRequestBase req, HttpResponse res) {
            this.method = method;
            this.reqUrl = reqUrl;
            this.req = req;
            this.res = res;
        }
    }
}

